/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.OptionalInt;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.content.recipe.RecipeBookRecipe;
import net.tslat.aoa3.util.RecipeUtil;
import org.jetbrains.annotations.Nullable;

public class ArcanumBatteryAttachRecipe
extends CustomRecipe
implements RecipeBookRecipe<CraftingInput> {
    private final RecipeUtil.RecipeBookDetails recipeBookDetails;
    private final NonNullList<Ingredient> ingredients;

    public ArcanumBatteryAttachRecipe(String group, @Nullable CraftingBookCategory category, boolean showObtainNotification) {
        this(new RecipeUtil.RecipeBookDetails(group, category, showObtainNotification));
    }

    public ArcanumBatteryAttachRecipe(RecipeUtil.RecipeBookDetails recipeBookDetails) {
        super(recipeBookDetails.category());
        this.recipeBookDetails = recipeBookDetails;
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of(AoATags.Items.STAVES), Ingredient.of((ItemLike[])new ItemLike[]{AoATools.ARCANUM_BATTERY})});
    }

    @Override
    public RecipeUtil.RecipeBookDetails recipeBookDetails() {
        return this.recipeBookDetails;
    }

    public RecipeSerializer<ArcanumBatteryAttachRecipe> getSerializer() {
        return (RecipeSerializer)AoARecipes.ARCANUM_BATTERY_ATTACH.serializer().get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(CraftingInput input, Level level) {
        if (this.ingredients.size() != input.ingredientCount()) {
            return false;
        }
        for (ItemStack stack : input.items()) {
            if (!stack.is(AoATags.Items.STAVES) || !BaseStaff.StoredCasts.getIfPresent(stack).map(storedCasts -> storedCasts.stored() >= 0).orElse(false).booleanValue()) continue;
            return false;
        }
        return input.stackedContents().canCraft((Recipe)this, null);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider holderLookup) {
        ItemStack staff = ItemStack.EMPTY;
        for (ItemStack stack : input.items()) {
            if (!stack.is(AoATags.Items.STAVES)) continue;
            staff = stack.copy();
            staff.set(AoADataComponents.STORED_SPELL_CASTS, (Object)new BaseStaff.StoredCasts(0, OptionalInt.empty()));
            break;
        }
        return staff;
    }

    public static class Factory
    implements RecipeSerializer<ArcanumBatteryAttachRecipe> {
        public static final MapCodec<ArcanumBatteryAttachRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> RecipeUtil.RecipeBookDetails.codec(builder, instance -> instance.recipeBookDetails).apply((Applicative)builder, ArcanumBatteryAttachRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ArcanumBatteryAttachRecipe> STREAM_CODEC = StreamCodec.composite(RecipeUtil.RecipeBookDetails.STREAM_CODEC, recipe -> recipe.recipeBookDetails, ArcanumBatteryAttachRecipe::new);

        public MapCodec<ArcanumBatteryAttachRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ArcanumBatteryAttachRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

