/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.mobeffect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.effectslib.api.ExtendedMobEffect;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import org.jetbrains.annotations.Nullable;

public class BleedingEffect
extends ExtendedMobEffect {
    public BleedingEffect() {
        super(MobEffectCategory.HARMFUL, ColourUtil.RGB(128, 5, 0));
    }

    public boolean shouldCureEffect(MobEffectInstance effectInstance, ItemStack stack, LivingEntity entity) {
        return stack.getItem() == Items.ENCHANTED_GOLDEN_APPLE;
    }

    public boolean shouldTickEffect(@Nullable MobEffectInstance effectInstance, @Nullable LivingEntity entity, int ticksRemaining, int amplifier) {
        int interval = 100 >> amplifier;
        return interval == 0 || ticksRemaining % interval == 0;
    }

    public boolean tick(LivingEntity entity, @Nullable MobEffectInstance effectInstance, int amplifier) {
        if (!entity.level().isClientSide && !entity.getType().is(EntityTypeTags.UNDEAD)) {
            entity.hurt(DamageUtil.miscDamage(AoADamageTypes.BLEED, entity.level()), 0.75f);
            TELParticlePacket packet = new TELParticlePacket(20);
            for (int i = 0; i < 20; ++i) {
                packet.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.SPLASH, (Entity)entity).colourOverride(0.75f, 0.0f, 0.0f, 1.0f).spawnNTimes(5).velocity(entity.getRandom().nextGaussian() * (double)0.01f, entity.getRandom().nextGaussian() * (double)0.01f, entity.getRandom().nextGaussian() * (double)0.01f));
            }
            packet.sendToAllPlayersTrackingEntity((ServerLevel)entity.level(), (Entity)entity);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.causeFoodExhaustion(5.0f);
            }
        }
        return true;
    }

    public void onApplication(@Nullable MobEffectInstance effectInstance, @Nullable Entity source, LivingEntity entity, int amplifier) {
        if (effectInstance != null) {
            effectInstance.visible = false;
        }
    }

    public MobEffectInstance onReapplication(MobEffectInstance existingEffectInstance, MobEffectInstance newEffectInstance, LivingEntity entity) {
        if (existingEffectInstance.getAmplifier() >= newEffectInstance.getAmplifier()) {
            return new MobEffectInstance(newEffectInstance.getEffect(), Math.max(newEffectInstance.getDuration(), existingEffectInstance.getDuration()), Mth.clamp((int)(existingEffectInstance.getAmplifier() + 1), (int)0, (int)127), newEffectInstance.isAmbient(), newEffectInstance.isVisible(), newEffectInstance.showIcon(), newEffectInstance.hiddenEffect);
        }
        return newEffectInstance;
    }
}

