/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class RollExtraTablesLootModifier
extends LootModifier {
    public static final MapCodec<RollExtraTablesLootModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> RollExtraTablesLootModifier.codecStart((RecordCodecBuilder.Instance)builder).and((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).listOf().fieldOf("tables").forGetter(instance -> instance.additionalTables)).apply((Applicative)builder, RollExtraTablesLootModifier::new));
    private final List<ResourceKey<LootTable>> additionalTables;

    public RollExtraTablesLootModifier(LootItemCondition[] conditions, ResourceLocation ... additionalTables) {
        this(conditions, Arrays.stream(additionalTables).map(id -> ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id)).toList());
    }

    public RollExtraTablesLootModifier(LootItemCondition[] conditions, List<ResourceKey<LootTable>> additionalTables) {
        super(conditions);
        this.additionalTables = additionalTables;
    }

    public MapCodec<RollExtraTablesLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        HolderGetter.Provider lookup = context.getResolver();
        for (ResourceKey<LootTable> tableKey : this.additionalTables) {
            lookup.get(Registries.LOOT_TABLE, tableKey).ifPresent(table -> ((LootTable)table.value()).getRandomItemsRaw(context, LootTable.createStackSplitter((ServerLevel)context.getLevel(), arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0))));
        }
        return generatedLoot;
    }
}

