/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.modifier;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.util.LootUtil;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.NotNull;

public class HavenLootModifier
extends LootModifier {
    public static final MapCodec<HavenLootModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> HavenLootModifier.codecStart((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, HavenLootModifier::new));
    public static final ResourceLocation HAVEN_LOOT_TABLE = AdventOfAscension.id("worlds/haven_passive");

    public HavenLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (WorldUtil.isWorld((ServerLevelAccessor)context.getLevel(), AoADimensions.HAVEN) && context.hasParam(LootContextParams.THIS_ENTITY) && context.hasParam(LootContextParams.ORIGIN) && !context.hasParam(LootContextParams.ATTACKING_ENTITY) && !context.hasParam(LootContextParams.DIRECT_ATTACKING_ENTITY) && (!context.hasParam(LootContextParams.BLOCK_STATE) || context.getRandom().nextInt(10) == 0)) {
            generatedLoot.addAll(LootUtil.generateLoot(HAVEN_LOOT_TABLE, new LootParams.Builder(context.getLevel()).withParameter(LootContextParams.THIS_ENTITY, (Object)((Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY))).withParameter(LootContextParams.ORIGIN, (Object)((Vec3)context.getParamOrNull(LootContextParams.ORIGIN))).create(LootContextParamSets.GIFT)));
        }
        return generatedLoot;
    }
}

