/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.loot.AoALootFunctions;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class GrantSkillXp
extends LootItemConditionalFunction {
    public static final MapCodec<GrantSkillXp> CODEC = RecordCodecBuilder.mapCodec(builder -> GrantSkillXp.commonFields((RecordCodecBuilder.Instance)builder).and(builder.group((App)Codec.lazyInitialized(AoARegistries.AOA_SKILLS::lookupCodec).fieldOf("skill").forGetter(GrantSkillXp::getSkill), (App)NumberProviders.CODEC.fieldOf("xp").forGetter(GrantSkillXp::getXp))).apply((Applicative)builder, GrantSkillXp::new));
    private final AoASkill skill;
    private final NumberProvider xp;

    protected GrantSkillXp(List<LootItemCondition> lootConditions, AoASkill skill, NumberProvider xp) {
        super(lootConditions);
        this.skill = skill;
        this.xp = xp;
    }

    public LootItemFunctionType<GrantSkillXp> getType() {
        return (LootItemFunctionType)AoALootFunctions.GRANT_SKILL_XP.get();
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.DIRECT_ATTACKING_ENTITY);
        if (entity == null) {
            entity = (Entity)context.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        }
        if (!(entity instanceof Player)) {
            entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            PlayerUtil.giveXpToPlayer(pl, this.skill, this.xp.getFloat(context), false);
        }
        return stack;
    }

    public AoASkill getSkill() {
        return this.skill;
    }

    public NumberProvider getXp() {
        return this.xp;
    }

    public static LootItemConditionalFunction.Builder<?> builder(AoASkill skill, float xp) {
        return GrantSkillXp.builder(skill, (NumberProvider)ConstantValue.exactly((float)xp));
    }

    public static LootItemConditionalFunction.Builder<?> builder(AoASkill skill, NumberProvider xp) {
        return GrantSkillXp.simpleBuilder(conditions -> new GrantSkillXp((List<LootItemCondition>)conditions, skill, xp));
    }
}

