/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.tslat.aoa3.common.registration.loot.AoALootConditions;
import org.jetbrains.annotations.Nullable;

public record WearingOrHoldingItem(LootContext.EntityTarget target, ItemPredicate predicate, Optional<EquipmentSlot> slot) implements LootItemCondition
{
    public static final MapCodec<WearingOrHoldingItem> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)LootContext.EntityTarget.CODEC.fieldOf("target").forGetter(WearingOrHoldingItem::target), (App)ItemPredicate.CODEC.fieldOf("predicate").forGetter(WearingOrHoldingItem::predicate), (App)StringRepresentable.fromEnum(EquipmentSlot::values).optionalFieldOf("slot").forGetter(WearingOrHoldingItem::slot)).apply((Applicative)builder, WearingOrHoldingItem::new));

    public LootItemConditionType getType() {
        return (LootItemConditionType)AoALootConditions.HOLDING_ITEM.get();
    }

    public static LootItemCondition.Builder checkingForSlot(LootContext.EntityTarget entity, ItemPredicate predicate, @Nullable EquipmentSlot slot) {
        return () -> new WearingOrHoldingItem(entity, predicate, Optional.ofNullable(slot));
    }

    public static LootItemCondition.Builder checking(LootContext.EntityTarget entity, ItemPredicate predicate) {
        return WearingOrHoldingItem.checkingForSlot(entity, predicate, null);
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(this.target.getParam());
    }

    public boolean test(LootContext lootContext) {
        Object object = lootContext.getParamOrNull(this.target.getParam());
        if (object instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)object;
            return this.slot.map(specifiedSlot -> this.predicate.test(entity.getItemBySlot(specifiedSlot))).orElseGet(() -> {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    if (!this.predicate.test(entity.getItemBySlot(slot))) continue;
                    return true;
                }
                return false;
            });
        }
        return false;
    }
}

