/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.condition;

import com.mojang.serialization.MapCodec;
import java.util.Set;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.tslat.aoa3.common.registration.loot.AoALootConditions;

public record IsBaby() implements LootItemCondition
{
    public static final MapCodec<IsBaby> CODEC = MapCodec.unit(IsBaby::new);

    public LootItemConditionType getType() {
        return (LootItemConditionType)AoALootConditions.IS_BABY.get();
    }

    public static LootItemCondition.Builder instance() {
        return IsBaby::new;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.THIS_ENTITY);
    }

    public boolean test(LootContext lootContext) {
        AgeableMob ageable;
        Entity entity = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        return entity instanceof AgeableMob && (ageable = (AgeableMob)entity).getAge() < 0;
    }
}

