/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.vulcane;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.AoASoundBuilderPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.item.datacomponent.VulcaneStats;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public abstract class BaseVulcane
extends Item {
    public BaseVulcane(Item.Properties properties) {
        super(properties);
    }

    public VulcaneStats vulcaneStats(ItemStack stack) {
        return (VulcaneStats)stack.get((DataComponentType)AoADataComponents.VULCANE_STATS.get());
    }

    public double getVulcaneDamage(ItemStack stack) {
        return this.vulcaneStats(stack).damage();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!(player instanceof ServerPlayer)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        AoAResource.Instance rage = PlayerUtil.getResource(player, (AoAResource)AoAResources.RAGE.get());
        if (!rage.hasAmount(50.0f) || player.getLastHurtByMob() == null) {
            return InteractionResultHolder.fail((Object)stack);
        }
        return this.activate(rage, stack, hand);
    }

    public InteractionResultHolder<ItemStack> activate(AoAResource.Instance rage, ItemStack vulcane, InteractionHand hand) {
        ServerPlayer pl = rage.getPlayerDataManager().getPlayer();
        float targetHealth = pl.getLastHurtByMob().getHealth();
        float damage = (float)this.getVulcaneDamage(vulcane) * (1.0f + (rage.getCurrentValue() - 50.0f) / 100.0f);
        if (DamageUtil.doVulcaneAttack((Entity)pl, (Entity)pl.getLastHurtByMob(), damage)) {
            this.doAdditionalEffect(pl.getLastHurtByMob(), (Player)pl, Math.min(targetHealth, damage));
            AoANetworking.sendToAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder((SoundEvent)AoASounds.ITEM_VULCANE_USE.get()).isPlayer().followEntity((Entity)pl)), (Entity)pl);
            ItemUtil.damageItemForUser((Player)pl, vulcane, hand);
            rage.consume(rage.getCurrentValue(), true);
            return InteractionResultHolder.success((Object)vulcane);
        }
        return InteractionResultHolder.fail((Object)vulcane);
    }

    public void doAdditionalEffect(LivingEntity target, Player player, float damageDealt) {
    }

    public int getEnchantmentValue() {
        return 8;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(1, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.VULCANE_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{LocaleUtil.numToComponent(this.getVulcaneDamage(stack))}));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.VULCANE_COST, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.VULCANE_GRACE_PERIOD, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
    }
}

