/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.LocaleUtil;

public class ShroomusSword
extends BaseSword {
    public ShroomusSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
        Collection effects;
        if ((double)attackCooldown > 0.75 && !(effects = attacker.getActiveEffects()).isEmpty()) {
            ArrayList<MobEffectInstance> removableEffects = new ArrayList<MobEffectInstance>(effects.size());
            for (MobEffectInstance effect : effects) {
                if (((MobEffect)effect.getEffect().value()).isBeneficial()) continue;
                removableEffects.add(effect);
            }
            for (MobEffectInstance effect : removableEffects) {
                target.addEffect(effect);
                attacker.removeEffect(effect.getEffect());
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

