/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class ExplochronSword
extends BaseSword {
    public ExplochronSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
        if (attackCooldown > 0.75f) {
            double offset = (double)target.getBbWidth() / 1.99;
            double offsetX = Mth.clamp((double)(attacker.getX() - target.getX()), (double)(-offset), (double)offset);
            double offsetY = Mth.clamp((double)(attacker.getY() + (double)attacker.getEyeHeight() - target.getY()), (double)-0.1, (double)((double)target.getBbHeight() + 0.1));
            double offsetZ = Mth.clamp((double)(attacker.getZ() - target.getZ()), (double)(-offset), (double)offset);
            WorldUtil.createExplosion((Entity)attacker, attacker.level(), target.getX() + offsetX, target.getY() + offsetY, target.getZ() + offsetZ, 1.75f);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

