/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import net.minecraft.core.component.DataComponents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.tslat.aoa3.common.registration.item.AoADataComponents;

public class BaseSword
extends SwordItem {
    public BaseSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public BaseSword(Tier tier, Item.Properties properties, Tool toolComponent) {
        super(tier, properties, toolComponent);
    }

    public float getBaseDamage(ItemStack stack) {
        return (float)((ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY)).compute(0.0, EquipmentSlot.MAINHAND);
    }

    public float getDamageForAttack(LivingEntity target, LivingEntity attacker, ItemStack swordStack, DamageSource source, float baseDamage) {
        return baseDamage;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        stack.set(AoADataComponents.MELEE_SWING_STRENGTH, (Object)Float.valueOf(player.getAttackStrengthScale(0.0f)));
        return false;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.doMeleeEffect(stack, target, attacker, BaseSword.getSwingEffectiveness(stack));
        return super.hurtEnemy(stack, target, attacker);
    }

    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
    }

    protected static float getSwingEffectiveness(ItemStack stack) {
        return ((Float)stack.getOrDefault(AoADataComponents.MELEE_SWING_STRENGTH, (Object)Float.valueOf(1.0f))).floatValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean isCriticalHit(LivingEntity attacker, Entity target, float attackStrengthScale) {
        if (!(attacker instanceof Player)) return false;
        Player pl = (Player)attacker;
        if (!(attackStrengthScale > 0.848f)) return false;
        if (!(pl.fallDistance > 0.0f)) return false;
        if (pl.onGround()) return false;
        if (pl.onClimbable()) return false;
        if (pl.isInWater()) return false;
        if (pl.hasEffect(MobEffects.BLINDNESS)) return false;
        if (pl.isPassenger()) return false;
        if (!(target instanceof LivingEntity)) return false;
        if (pl.isSprinting()) return false;
        return true;
    }

    public static Item.Properties baseProperties(Tier tier) {
        return BaseSword.baseProperties(tier, -2.4f);
    }

    public static Item.Properties baseProperties(Tier tier, float attackSpeed) {
        return BaseSword.baseProperties(tier, 0.0f, attackSpeed);
    }

    public static Item.Properties baseProperties(Tier tier, float attackDamageMod, float attackSpeed) {
        return new Item.Properties().attributes(BaseSword.createAttributes((Tier)tier, (float)attackDamageMod, (float)attackSpeed));
    }

    public static ItemAttributeModifiers createAttributes(Tier tier, float attackSpeed) {
        return BaseSword.createAttributes((Tier)tier, (int)0, (float)attackSpeed);
    }
}

