/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class ShowStaff
extends BaseStaff<List<LivingEntity>> {
    public ShowStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_SHOW_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.COMPASS_RUNE.get()), 3);
            runes.put((Object)((Item)AoAItems.POWER_RUNE.get()), 3);
        });
    }

    @Override
    public Optional<List<LivingEntity>> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List targets = EntityRetrievalUtil.getEntities((Entity)caster, (double)30.0, entity -> {
            LivingEntity livingEntity;
            return entity instanceof LivingEntity && EntityUtil.isHostileMob((Entity)(livingEntity = (LivingEntity)entity));
        });
        return Optional.ofNullable(targets.isEmpty() ? null : targets);
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, List<LivingEntity> args) {
        for (LivingEntity entity : args) {
            entity.igniteForSeconds(5.0f);
            EntityUtil.applyPotions((Entity)entity, new EffectBuilder(MobEffects.GLOWING, 100));
            level.addFreshEntity((Entity)new FireworkRocketEntity((Level)level, entity.getX(), entity.getBoundingBox().maxY, entity.getZ(), this.makeFireworksStack()));
        }
    }

    private ItemStack makeFireworksStack() {
        ItemStack fireworks = new ItemStack((ItemLike)Items.FIREWORK_ROCKET, 1);
        fireworks.set(DataComponents.FIREWORKS, (Object)new Fireworks(3, List.of(new FireworkExplosion(FireworkExplosion.Shape.BURST, IntList.of((int)0), IntList.of(), true, false))));
        return fireworks;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

