/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.TagUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import org.jetbrains.annotations.Nullable;

public class ReefStaff
extends BaseStaff<Boolean> {
    private static final Supplier<Map<Block, Block>> CORALS = Suppliers.memoize(() -> (Map)Util.make(new IdentityHashMap(), map -> {
        map.put(Blocks.DEAD_TUBE_CORAL_BLOCK, Blocks.TUBE_CORAL_BLOCK);
        map.put(Blocks.DEAD_BRAIN_CORAL_BLOCK, Blocks.BRAIN_CORAL_BLOCK);
        map.put(Blocks.DEAD_BUBBLE_CORAL_BLOCK, Blocks.BUBBLE_CORAL_BLOCK);
        map.put(Blocks.DEAD_FIRE_CORAL_BLOCK, Blocks.FIRE_CORAL_BLOCK);
        map.put(Blocks.DEAD_HORN_CORAL_BLOCK, Blocks.HORN_CORAL_BLOCK);
        map.put(Blocks.DEAD_TUBE_CORAL, Blocks.TUBE_CORAL);
        map.put(Blocks.DEAD_BRAIN_CORAL, Blocks.BRAIN_CORAL);
        map.put(Blocks.DEAD_BUBBLE_CORAL, Blocks.BUBBLE_CORAL);
        map.put(Blocks.DEAD_FIRE_CORAL, Blocks.FIRE_CORAL);
        map.put(Blocks.DEAD_HORN_CORAL, Blocks.HORN_CORAL);
        map.put(Blocks.DEAD_TUBE_CORAL_FAN, Blocks.TUBE_CORAL_FAN);
        map.put(Blocks.DEAD_BRAIN_CORAL_FAN, Blocks.BRAIN_CORAL_FAN);
        map.put(Blocks.DEAD_BUBBLE_CORAL_FAN, Blocks.BUBBLE_CORAL_FAN);
        map.put(Blocks.DEAD_FIRE_CORAL_FAN, Blocks.FIRE_CORAL_FAN);
        map.put(Blocks.DEAD_HORN_CORAL_FAN, Blocks.HORN_CORAL_FAN);
        map.put(Blocks.DEAD_TUBE_CORAL_WALL_FAN, Blocks.TUBE_CORAL_WALL_FAN);
        map.put(Blocks.DEAD_BRAIN_CORAL_WALL_FAN, Blocks.BRAIN_CORAL_WALL_FAN);
        map.put(Blocks.DEAD_BUBBLE_CORAL_WALL_FAN, Blocks.BUBBLE_CORAL_WALL_FAN);
        map.put(Blocks.DEAD_FIRE_CORAL_WALL_FAN, Blocks.FIRE_CORAL_WALL_FAN);
        map.put(Blocks.DEAD_HORN_CORAL_WALL_FAN, Blocks.HORN_CORAL_WALL_FAN);
    }));

    public ReefStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_REEF_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.ENERGY_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.WATER_RUNE.get()), 1);
        });
    }

    @Override
    public Optional<Boolean> checkPreconditions(LivingEntity caster, ItemStack staff) {
        return Optional.ofNullable(WorldUtil.canPlaceBlock((LevelAccessor)caster.level(), caster.blockPosition(), (Entity)caster, staff) && caster.isInWater() ? Boolean.valueOf(true) : null);
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, Boolean args) {
        ServerLevel serverLevel;
        Vec3 lookAngle = caster.getLookAngle();
        if (lookAngle.horizontalDistanceSqr() > 1.0E-7 || lookAngle.y != -1.0) {
            caster.setDeltaMovement(lookAngle.scale(3.0));
            caster.hurtMarked = true;
            if (level instanceof ServerLevel) {
                serverLevel = level;
                for (int i = 0; i < 10; ++i) {
                    AoAScheduler.scheduleSyncronisedTask(() -> new TELParticlePacket(new ParticleBuilder[]{ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, (Entity)caster).spawnNTimes(3)}).sendToAllPlayersTrackingEntity(serverLevel, (Entity)caster), i + 1);
                }
            }
        }
        if (level instanceof ServerLevel) {
            serverLevel = level;
            ReefStaff.doPlantGrowth(serverLevel, caster);
        }
    }

    private static void doPlantGrowth(ServerLevel level, LivingEntity caster) {
        Map<Block, Block> coralMap = CORALS.get();
        TELParticlePacket packet = new TELParticlePacket();
        for (int i = 0; i < 50; ++i) {
            BlockPos pos = BlockPos.containing((Position)caster.position().add(caster.getRandom().nextGaussian() * 3.0, caster.getRandom().nextGaussian() * 3.0, caster.getRandom().nextGaussian() * 3.0));
            BlockState state = level.getBlockState(pos);
            if (coralMap.containsKey(state.getBlock())) {
                level.setBlockAndUpdate(pos, coralMap.get(state.getBlock()).defaultBlockState());
            } else if (state.is(Blocks.KELP) || state.is(Blocks.SEAGRASS) || state.is(Blocks.KELP_PLANT)) {
                ((BonemealableBlock)state.getBlock()).performBonemeal(level, level.random, pos, state);
            } else {
                if (state.getBlock() != Blocks.WATER || level.getFluidState(pos).getAmount() != 8) continue;
                if (level.random.nextInt(10) == 0) {
                    BlockState pickles = Blocks.SEA_PICKLE.defaultBlockState();
                    if (!pickles.canSurvive((LevelReader)level, pos)) continue;
                    BlockState existingState = level.getBlockState(pos);
                    if (existingState.getBlock() == Blocks.SEA_PICKLE) {
                        pickles.setValue((Property)SeaPickleBlock.PICKLES, (Comparable)Integer.valueOf(Math.min(4, (Integer)existingState.getValue((Property)SeaPickleBlock.PICKLES) + 1)));
                    }
                    level.setBlockAndUpdate(pos, pickles);
                } else {
                    BlockState growthState;
                    BlockState blockState = growthState = level.random.nextBoolean() ? Blocks.SEAGRASS.defaultBlockState() : Blocks.KELP_PLANT.defaultBlockState();
                    if (level.random.nextBoolean()) {
                        TagKey tag = switch (level.random.nextInt(4)) {
                            case 0 -> BlockTags.UNDERWATER_BONEMEALS;
                            case 1 -> BlockTags.CORAL_PLANTS;
                            case 2 -> BlockTags.WALL_CORALS;
                            default -> BlockTags.CORALS;
                        };
                        growthState = TagUtil.getTagContents(tag, (Level)level).flatMap(set -> set.getRandomElement(level.random)).map(holder -> ((Block)holder.value()).defaultBlockState()).orElse(growthState);
                    }
                    if (growthState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                        Vec3 angle = caster.getEyePosition().vectorTo(Vec3.atCenterOf((Vec3i)pos));
                        growthState = (BlockState)growthState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.getNearest((double)angle.x, (double)angle.y, (double)angle.z));
                        for (int j = 0; j < 4 && !growthState.canSurvive((LevelReader)level, pos); ++j) {
                            growthState = (BlockState)growthState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(level.random));
                        }
                    }
                    if (!growthState.canSurvive((LevelReader)level, pos)) continue;
                    level.setBlockAndUpdate(pos, growthState);
                }
            }
            packet.particle(ParticleBuilder.forRandomPosInBounds((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (AABB)new AABB(pos)).spawnNTimes(10));
            packet.particle(ParticleBuilder.forRandomPosInBounds((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, (AABB)new AABB(pos)).spawnNTimes(10));
        }
        if (!packet.isEmpty()) {
            packet.sendToAllPlayersTrackingEntity(level, (Entity)caster);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

