/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.NoxiousShotEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import org.jetbrains.annotations.Nullable;

public class NoxiousStaff
extends BaseStaff<Object> {
    public NoxiousStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_NOXIOUS_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.WIND_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.POISON_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.STORM_RUNE.get()), 2);
        });
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, Object args) {
        level.addFreshEntity((Entity)new NoxiousShotEntity(caster, this, 60, 0.0f, 0.0f, 0.0f));
        level.addFreshEntity((Entity)new NoxiousShotEntity(caster, this, 60, 0.075f, 0.075f, 0.0f));
        level.addFreshEntity((Entity)new NoxiousShotEntity(caster, this, 60, -0.075f, 0.0f, 0.075f));
        level.addFreshEntity((Entity)new NoxiousShotEntity(caster, this, 60, 0.0f, -0.075f, -0.075f));
        level.addFreshEntity((Entity)new NoxiousShotEntity(caster, this, 60, -0.075f, 0.075f, -0.075f));
        level.addFreshEntity((Entity)new NoxiousShotEntity(caster, this, 60, -0.075f, -0.075f, 0.075f));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (DamageUtil.doMagicProjectileAttack((Entity)shooter, (Entity)shot, target, this.getDmg())) {
            EntityUtil.applyPotions(target, new EffectBuilder(MobEffects.POISON, 100).level(3));
            return true;
        }
        return false;
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 pos, LivingEntity shooter) {
        AreaEffectCloud cloud = new AreaEffectCloud(shot.level(), shot.getX(), shot.getY(), shot.getZ());
        cloud.setRadius(3.0f);
        cloud.setPotionContents(new PotionContents(Optional.of(Potions.STRONG_POISON), Optional.of(ColourUtil.RGB(51, 102, 0)), List.of(new MobEffectInstance(MobEffects.POISON, 100, 2, true, true))));
        cloud.setDuration(3);
        cloud.setOwner(shooter);
        shot.level().addFreshEntity((Entity)cloud);
    }

    @Override
    public float getDmg() {
        return 7.0f;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

