/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.levelgen.Heightmap;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class LightningStaff
extends BaseStaff<BlockPos> {
    public LightningStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.COMPASS_RUNE.get()), 1);
            runes.put((Object)((Item)AoAItems.STRIKE_RUNE.get()), 4);
            runes.put((Object)((Item)AoAItems.STORM_RUNE.get()), 4);
        });
    }

    @Override
    public Optional<BlockPos> checkPreconditions(LivingEntity caster, ItemStack staff) {
        return Optional.ofNullable(PlayerUtil.getBlockAimingAt(caster, 70.0));
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, BlockPos args) {
        if (level instanceof ServerLevel) {
            for (int i = 0; i <= 360; i += 18) {
                double posX = (double)args.getX() + Math.cos(i) * 4.0;
                double posZ = (double)args.getZ() + Math.sin(i) * 4.0;
                WorldUtil.spawnLightning(level, caster instanceof ServerPlayer ? (ServerPlayer)caster : null, posX, level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, BlockPos.containing((double)posX, (double)0.0, (double)posZ)).getY(), posZ, true, false);
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

