/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.GhoulShotEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class GhoulStaff
extends BaseStaff<Object> {
    public GhoulStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.WIND_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.DISTORTION_RUNE.get()), 1);
            runes.put((Object)((Item)AoAItems.LIFE_RUNE.get()), 2);
        });
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, Object args) {
        level.addFreshEntity((Entity)new GhoulShotEntity(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        return DamageUtil.doMagicProjectileAttack((Entity)shooter, (Entity)shot, target, RandomUtil.randomNumberBetween((int)16, (int)42));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.RANDOM_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.literal((String)"16"), Component.literal((String)"42")}));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

