/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class FungalStaff
extends BaseStaff<Object2BooleanArrayMap<BlockPos>> {
    public FungalStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_FUNGAL_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.DISTORTION_RUNE.get()), 5);
            runes.put((Object)((Item)AoAItems.LIFE_RUNE.get()), 2);
        });
    }

    @Override
    public Optional<Object2BooleanArrayMap<BlockPos>> checkPreconditions(LivingEntity caster, ItemStack staff) {
        Object2BooleanArrayMap workablePositions = new Object2BooleanArrayMap();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    MushroomBlock mushroom;
                    BlockPos pos = BlockPos.containing((double)(caster.getX() + (double)x), (double)(caster.getY() + (double)y), (double)(caster.getZ() + (double)z));
                    BlockState state = caster.level().getBlockState(pos);
                    Block block = state.getBlock();
                    if (block == Blocks.GRASS_BLOCK) {
                        if (!WorldUtil.canModifyBlock((LevelAccessor)caster.level(), pos, (Entity)caster, staff)) continue;
                        workablePositions.put((Object)pos, true);
                        continue;
                    }
                    if (!(block instanceof MushroomBlock) || !(mushroom = (MushroomBlock)block).isValidBonemealTarget((LevelReader)caster.level(), pos, state) || !WorldUtil.canModifyBlock((LevelAccessor)caster.level(), pos, (Entity)caster, staff)) continue;
                    workablePositions.put((Object)pos, false);
                }
            }
        }
        return Optional.ofNullable(workablePositions.isEmpty() ? null : workablePositions);
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, Object2BooleanArrayMap<BlockPos> args) {
        if (level instanceof ServerLevel) {
            for (Object2BooleanMap.Entry entry : args.object2BooleanEntrySet()) {
                BlockPos pos = (BlockPos)entry.getKey();
                if (entry.getBooleanValue()) {
                    level.setBlockAndUpdate(pos, Blocks.MYCELIUM.defaultBlockState());
                } else {
                    BlockState state = level.getBlockState(pos);
                    MushroomBlock mushroom = (MushroomBlock)state.getBlock();
                    if (mushroom.isBonemealSuccess((Level)level, RandomUtil.RANDOM.getSource(), pos, state)) {
                        mushroom.performBonemeal(level, RandomUtil.RANDOM.getSource(), pos, state);
                    }
                }
                level.levelEvent(1505, pos, 0);
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

