/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.FireflyShotEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class FireflyStaff
extends BaseStaff<Object> {
    public FireflyStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_FIREFLY_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.WIND_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.STRIKE_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.FIRE_RUNE.get()), 1);
        });
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, Object args) {
        level.addFreshEntity((Entity)new FireflyShotEntity(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (DamageUtil.doMagicProjectileAttack((Entity)shooter, (Entity)shot, target, this.getDmg())) {
            target.igniteForSeconds(5.0f);
            UUID targetUUID = target.getUUID();
            if (targetUUID.equals(((FireflyShotEntity)shot).lastTargetUUID)) {
                return true;
            }
            for (int i = 0; i < RandomUtil.randomNumberBetween((int)1, (int)7); ++i) {
                shot.level().addFreshEntity((Entity)new FireflyShotEntity(shooter, this, (FireflyShotEntity)shot, targetUUID, RandomUtil.randomScaledGaussianValue((double)0.35f), (double)1.4f, RandomUtil.randomScaledGaussianValue((double)0.35f)));
            }
            return true;
        }
        return false;
    }

    @Override
    public float getDmg() {
        return 22.0f;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

