/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import org.jetbrains.annotations.Nullable;

public class EverfightStaff
extends BaseStaff<Float> {
    public EverfightStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_EVER_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.KINETIC_RUNE.get()), 4);
            runes.put((Object)((Item)AoAItems.POWER_RUNE.get()), 4);
        });
    }

    @Override
    public Optional<Float> checkPreconditions(LivingEntity caster, ItemStack staff) {
        float healthPercent = EntityUtil.getHealthPercent(caster);
        return Optional.ofNullable(healthPercent < 1.0f && healthPercent > 0.0f ? Float.valueOf(healthPercent) : null);
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, Float args) {
        EntityUtil.applyPotions((Entity)caster, new EffectBuilder(MobEffects.DAMAGE_RESISTANCE, (int)(1200.0f * (1.0f - args.floatValue()))));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

