/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.CelestialFallEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class CelestialStaff
extends BaseStaff<BlockPos> {
    public CelestialStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CELESTIAL_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.COMPASS_RUNE.get()), 1);
            runes.put((Object)((Item)AoAItems.LUNAR_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.ENERGY_RUNE.get()), 2);
        });
    }

    @Override
    public Optional<BlockPos> checkPreconditions(LivingEntity caster, ItemStack staff) {
        return Optional.ofNullable(PlayerUtil.getBlockAimingAt(caster, 70.0));
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, BlockPos args) {
        BlockPos pos = args;
        level.addFreshEntity((Entity)new CelestialFallEntity(caster, this, pos.getX(), pos.getY() + 25, pos.getZ(), 3.0f));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 hitPos, LivingEntity shooter) {
        WorldUtil.createExplosion((Entity)shooter, shot.level(), (Entity)shot, 2.5f);
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        WorldUtil.createExplosion((Entity)shooter, shot.level(), (Entity)shot, 2.5f);
        return DamageUtil.doMagicProjectileAttack((Entity)shooter, (Entity)shot, target, this.getDmg());
    }

    @Override
    public float getDmg() {
        return 22.0f;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

