/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.api.particle.transitionworker.FollowEntityParticleTransition;
import net.tslat.effectslib.api.particle.transitionworker.ParticleTransitionWorker;
import net.tslat.effectslib.api.util.EffectBuilder;
import org.jetbrains.annotations.Nullable;

public class AmberStaff
extends BaseStaff<Object> {
    public AmberStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_AMBER_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.KINETIC_RUNE.get()), 1);
            runes.put((Object)((Item)AoAItems.ENERGY_RUNE.get()), 4);
        });
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, Object args) {
        EntityUtil.applyPotions((Entity)caster, new EffectBuilder(MobEffects.ABSORPTION, 600).level(2));
    }

    @Override
    public void doCastFx(ServerLevel level, ItemStack staff, LivingEntity caster, Object args) {
        int rings = Mth.ceil((float)(caster.getBbHeight() * 4.0f));
        for (int i = 0; i < rings; ++i) {
            int step = i;
            AoAScheduler.scheduleSyncronisedTask(() -> {
                ParticleBuilder.forPositionsInCircle((ParticleOptions)ParticleTypes.EXPLOSION, (Vec3)caster.position().add(0.0, (double)((float)step * 0.25f), 0.0), (double)(Mth.sin((float)((float)step / (float)rings + 0.5f)) * 0.25f), (int)32).scaleMod(0.15f).lifespan(rings + 3 - step).colourOverride(16225280).addTransition((ParticleTransitionWorker)FollowEntityParticleTransition.create((int)caster.getId())).sendToAllPlayersTrackingEntity((ServerLevel)caster.level(), (Entity)caster);
                ParticleBuilder.forPositionsInCircle((ParticleOptions)ParticleTypes.SPORE_BLOSSOM_AIR, (Vec3)caster.position().add(0.0, (double)((float)step * 0.25f), 0.0), (double)(Mth.sin((float)((float)step / (float)rings + 0.5f)) * 0.25f), (int)32).scaleMod(0.25f).lifespan(caster.getRandom().nextInt(10, 30)).colourOverride(16421888).sendToAllPlayersTrackingEntity((ServerLevel)caster.level(), (Entity)caster);
            }, i + 1);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

