/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.shotgun;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.DischargeShotEntity;
import net.tslat.aoa3.content.item.weapon.shotgun.BaseShotgun;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class DischargeShotgun
extends BaseShotgun {
    public DischargeShotgun(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_SHOTGUN_HEAVY_FIRE_LONG.get();
    }

    @Override
    public Item getAmmoItem() {
        return (Item)AoAItems.DISCHARGE_CAPSULE.get();
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPosition, float bulletDmgMultiplier) {
        WorldUtil.createExplosion((Entity)shooter, bullet.level(), (Entity)bullet, 2.5f);
    }

    @Override
    protected boolean fireGun(ServerLevel level, LivingEntity shooter, ItemStack stack, InteractionHand hand) {
        BaseBullet bullet = this.findAndConsumeAmmo(shooter, stack, hand);
        if (bullet == null) {
            return false;
        }
        int pellets = this.getPelletCount(stack);
        float spreadFactor = this.getSpreadFactor(shooter, stack, pellets);
        for (int i = 0; i < pellets; ++i) {
            DischargeShotEntity pellet = new DischargeShotEntity(shooter, this, hand, 4, 1.0f, 0, RandomUtil.randomValueUpTo((float)0.5f) * spreadFactor, RandomUtil.randomValueUpTo((float)0.5f) * spreadFactor, RandomUtil.randomValueUpTo((float)0.5f) * spreadFactor);
            level.addFreshEntity((Entity)pellet);
        }
        this.doFiringEffects(level, shooter, bullet, stack, hand);
        return true;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.set(1, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.EXPLODES_ON_HIT, LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add(2, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.FIRING_SPEED, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.literal((String)NumberUtil.roundToNthDecimalPlace(20.0f / (float)this.getTicksBetweenShots(stack), 2))}));
    }
}

