/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.shotgun;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.common.registration.item.AoAEnchantments;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.LimoniteBulletEntity;
import net.tslat.aoa3.content.entity.projectile.gun.MetalSlugEntity;
import net.tslat.aoa3.content.item.datacomponent.ShotgunStats;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class BaseShotgun
extends BaseGun {
    public BaseShotgun(Item.Properties properties) {
        super(properties);
    }

    public ShotgunStats shotgunStats() {
        return this.shotgunStats(this.getDefaultInstance());
    }

    public ShotgunStats shotgunStats(ItemStack stack) {
        return (ShotgunStats)stack.get((DataComponentType)AoADataComponents.SHOTGUN_STATS.get());
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_SHOTGUN_MEDIUM_FIRE_LONG.get();
    }

    @Override
    public Item getAmmoItem() {
        return (Item)AoAItems.SPREADSHOT.get();
    }

    @Override
    public boolean isFullAutomatic() {
        return false;
    }

    public int getPelletCount(ItemStack stack) {
        return this.shotgunStats(stack).pellets();
    }

    @Override
    protected boolean fireGun(ServerLevel level, LivingEntity shooter, ItemStack stack, InteractionHand hand) {
        BaseBullet bullet = this.findAndConsumeAmmo(shooter, stack, hand);
        if (bullet == null) {
            return false;
        }
        int pellets = this.getPelletCount(stack);
        float spreadFactor = this.getSpreadFactor(shooter, stack, pellets);
        for (int i = 0; i < pellets; ++i) {
            LimoniteBulletEntity pellet = new LimoniteBulletEntity(shooter, this, hand, 4, 1.0f, 0, RandomUtil.randomValueUpTo((float)0.5f) * spreadFactor, RandomUtil.randomValueUpTo((float)0.5f) * spreadFactor, RandomUtil.randomValueUpTo((float)0.5f) * spreadFactor);
            level.addFreshEntity((Entity)pellet);
        }
        this.doFiringEffects(level, shooter, bullet, stack, hand);
        return true;
    }

    protected float getSpreadFactor(LivingEntity shooter, ItemStack stack, int pellets) {
        float f;
        Level level = shooter.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            f = AoAEnchantments.modifyPelletSpread(level2, stack, 0.1f * (float)pellets);
        } else {
            f = 0.1f * (float)pellets;
        }
        return f;
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new MetalSlugEntity(shooter, this, hand, 4, 0);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.set(1, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.SHOTGUN_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.literal((String)NumberUtil.roundToNthDecimalPlace(this.getGunDamage(stack), 2)), LocaleUtil.numToComponent(this.getPelletCount(stack))}));
    }
}

