/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.maul;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.item.weapon.maul.BaseMaul;
import net.tslat.aoa3.library.constant.AttackSpeed;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public class ElectronMaul
extends BaseMaul {
    public ElectronMaul() {
        super(25.0f, AttackSpeed.THIRD, 2.5, 1500);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.getGameTime() % 10L == 0L && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float damageScaling = ((Float)stack.getOrDefault(AoADataComponents.DAMAGE_SCALING, (Object)Float.valueOf(0.0f))).floatValue();
            if (isSelected) {
                float currentCalcBuff = this.getKnockbackMultiplier(entity);
                if (damageScaling != currentCalcBuff) {
                    stack.set(AoADataComponents.DAMAGE_SCALING, (Object)Float.valueOf(currentCalcBuff));
                    livingEntity.getAttribute(Attributes.ATTACK_KNOCKBACK).addOrUpdateTransientModifier(this.getKnockbackModifier(damageScaling == 0.0f ? 1.0f : damageScaling));
                }
            } else if (damageScaling != 0.0f && livingEntity.getMainHandItem().isEmpty()) {
                livingEntity.getAttribute(Attributes.ATTACK_KNOCKBACK).addOrUpdateTransientModifier(this.getKnockbackModifier(1.0f));
                stack.set(AoADataComponents.DAMAGE_SCALING, (Object)Float.valueOf(0.0f));
            }
        }
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        float attackStr = player.getAttackStrengthScale(0.0f);
        stack.set(AoADataComponents.MELEE_SWING_STRENGTH, (Object)Float.valueOf(attackStr));
        player.getAttribute(Attributes.ATTACK_KNOCKBACK).addOrUpdateTransientModifier(this.getKnockbackModifier(attackStr * this.getKnockbackMultiplier((Entity)player)));
        return false;
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.doMeleeEffect(stack, (Entity)target, attacker, ((Float)stack.getOrDefault(AoADataComponents.MELEE_SWING_STRENGTH, (Object)Float.valueOf(1.0f))).floatValue());
            ItemUtil.damageItemForUser(level2, stack, attacker, InteractionHand.MAIN_HAND);
            attacker.getAttribute(Attributes.ATTACK_KNOCKBACK).addOrUpdateTransientModifier(this.getKnockbackModifier(1.0f * this.getKnockbackMultiplier((Entity)attacker)));
        }
        return true;
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, Entity target, LivingEntity attacker, float attackCooldown) {
        if (((Float)stack.getOrDefault(AoADataComponents.DAMAGE_SCALING, (Object)Float.valueOf(0.0f))).floatValue() > 0.75f) {
            WorldUtil.spawnLightning((ServerLevel)attacker.level(), (ServerPlayer)attacker, target.getX(), target.getY(), target.getZ(), false, false);
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            AoAResource.Instance spirit = PlayerUtil.getResource((Player)player, (AoAResource)AoAResources.SPIRIT.get());
            spirit.consume(spirit.getCurrentValue(), true);
        }
    }

    private float getKnockbackMultiplier(Entity holder) {
        if (holder instanceof Player) {
            Player pl = (Player)holder;
            AoAResource.Instance spirit = PlayerUtil.getResource(pl, (AoAResource)AoAResources.SPIRIT.get());
            return 1.0f + spirit.getCurrentValue() / spirit.getMaxValue();
        }
        return 1.0f;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }
}

