/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.ShoeShotEntity;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class ShoeFlinger
extends BaseGun {
    public ShoeFlinger(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_AIR_CANNON_FIRE.get();
    }

    @Override
    protected float getFiringSoundPitchAdjust() {
        return 0.85f;
    }

    @Override
    public Item getAmmoItem() {
        return Items.LEATHER_BOOTS;
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new ShoeShotEntity(shooter, this, hand, 120, 0);
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPos, float bulletDmgMultiplier) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            DamageUtil.doScaledKnockback(livingTarget, shooter, 1.35f, 1.0, 1.0, 1.0);
            if (shooter instanceof ServerPlayer && livingTarget.getHealth() == 0.0f && target.getType().is(Tags.EntityTypes.BOSSES)) {
                AdvancementUtil.grantCriterion((ServerPlayer)shooter, AdventOfAscension.id("overworld/la_chancla"), "shoe_flinger_boss_kill");
            }
            if (!livingTarget.hasItemInSlot(EquipmentSlot.FEET)) {
                livingTarget.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.LEATHER_BOOTS));
            }
        }
    }

    @Override
    protected void doFiringSound(LivingEntity shooter, BaseBullet bullet, ItemStack stack, InteractionHand hand) {
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), this.getFiringSound(), SoundSource.PLAYERS, 1.0f, this.getFiringSoundPitchAdjust() + (float)RandomUtil.randomScaledGaussianValue((double)0.01f));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

