/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import org.jetbrains.annotations.Nullable;

public class Minigun
extends BaseGun {
    public Minigun(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_MINIGUN_AUTOMATIC_FIRE.get();
    }

    @Override
    protected float getFiringSoundPitchAdjust() {
        return 1.0f;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity shooter, int timeCharged) {
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), (SoundEvent)AoASounds.ITEM_GUN_MINIGUN_WINDDOWN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    protected void doFiringSound(LivingEntity shooter, BaseBullet bullet, ItemStack stack, InteractionHand hand) {
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), this.getFiringSound(), SoundSource.PLAYERS, 1.0f, this.getFiringSoundPitchAdjust());
    }
}

