/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.builder.SoundBuilder;
import org.jetbrains.annotations.Nullable;

public class Megagun
extends BaseGun {
    public Megagun(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_MINIGUN_AUTOMATIC_FIRE.get();
    }

    @Override
    protected float getFiringSoundPitchAdjust() {
        return 0.95f;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity shooter, int timeCharged) {
        new SoundBuilder((Holder<SoundEvent>)AoASounds.ITEM_GUN_MINIGUN_WINDDOWN).isPlayer().atEntity((Entity)shooter).followEntity((Entity)shooter).execute();
    }

    @Override
    protected void doFiringSound(LivingEntity shooter, BaseBullet bullet, ItemStack stack, InteractionHand hand) {
        new SoundBuilder(this.getFiringSound()).isPlayer().atEntity((Entity)shooter).varyPitch(this.getFiringSoundPitchAdjust()).execute();
    }
}

