/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.crossbow;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.item.ArrowFiringWeapon;
import net.tslat.aoa3.content.item.datacomponent.CrossbowStats;
import net.tslat.aoa3.util.InteractionResults;
import net.tslat.aoa3.util.LocaleUtil;

public class BaseCrossbow
extends CrossbowItem
implements ArrowFiringWeapon {
    protected double damage;

    public BaseCrossbow(Item.Properties properties) {
        super(properties.component(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY));
    }

    public CrossbowStats crossbowStats() {
        return this.crossbowStats(this.getDefaultInstance());
    }

    public CrossbowStats crossbowStats(ItemStack stack) {
        return (CrossbowStats)stack.get((DataComponentType)AoADataComponents.CROSSBOW_STATS.get());
    }

    public double getCrossbowDamage(ItemStack stack) {
        return this.crossbowStats(stack).damage();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ChargedProjectiles loadedProjectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
        if (loadedProjectiles != null && !loadedProjectiles.isEmpty()) {
            this.performShooting(level, (LivingEntity)player, hand, stack, BaseCrossbow.getShootingPower((ChargedProjectiles)loadedProjectiles), 1.0f, null);
            return InteractionResults.ItemUse.succeedNoArmSwing(stack);
        }
        if (this.getAmmoStack((LivingEntity)player, stack).isEmpty()) {
            return InteractionResults.ItemUse.denyUsage(stack);
        }
        this.startSoundPlayed = false;
        this.midLoadSoundPlayed = false;
        player.startUsingItem(hand);
        return InteractionResults.ItemUse.succeedNoArmSwing(stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity shooter, int ticksRemaining) {
        int ticksCharged = this.getUseDuration(stack, shooter) - ticksRemaining;
        float chargePower = this.getPowerForTime(ticksCharged, stack, shooter);
        if (chargePower >= 1.0f && !BaseCrossbow.isCharged((ItemStack)stack) && this.tryLoadProjectiles(shooter, stack)) {
            level.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.CROSSBOW_LOADING_END, shooter.getSoundSource(), 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    protected boolean tryLoadProjectiles(LivingEntity shooter, ItemStack stack) {
        List ammoStacks = BaseCrossbow.draw((ItemStack)stack, (ItemStack)this.getAmmoStack(shooter, stack), (LivingEntity)shooter);
        if (ammoStacks.isEmpty()) {
            return false;
        }
        stack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((List)ammoStacks));
        return true;
    }

    protected float getPowerForTime(int useTicks, ItemStack pCrossbowStack, LivingEntity shooter) {
        return Math.min(1.0f, (float)useTicks / (float)BaseCrossbow.getChargeDuration((ItemStack)pCrossbowStack, (LivingEntity)shooter));
    }

    protected ItemStack getAmmoStack(LivingEntity shooter, ItemStack crossbowStack) {
        return shooter.getProjectile(crossbowStack);
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack stack, ItemStack ammoStack, boolean isCrit) {
        Projectile projectile = super.createProjectile(level, shooter, stack, ammoStack, isCrit);
        if (!(projectile instanceof AbstractArrow)) {
            return projectile;
        }
        AbstractArrow arrow = (AbstractArrow)projectile;
        return this.applyArrowMods(CustomArrowEntity.fromArrow(arrow, stack, shooter, this.getCrossbowDamage(stack)), (Entity)shooter, stack, isCrit);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(1, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.ARROW_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.literal((String)Double.toString(this.getCrossbowDamage(stack)))}));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.AMMO_ITEM, LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, new Component[]{Component.translatable((String)Items.ARROW.getDescriptionId())}));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }
}

