/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.cannon;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoAExplosions;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.entity.projectile.cannon.RPGEntity;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.cannon.BaseCannon;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class RPG
extends BaseCannon {
    public RPG(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_RPG_FIRE.get();
    }

    @Override
    public Item getAmmoItem() {
        return (Item)AoAWeapons.GRENADE.get();
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new RPGEntity(shooter, this, hand, 120, 0);
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPosition, float bulletDmgMultiplier) {
        if (target != null) {
            float damage;
            ItemStack stack;
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                bulletDmgMultiplier = (float)((double)bulletDmgMultiplier * (1.0 + (livingTarget.getAttributeValue(Attributes.ARMOR) * 1.5 + livingTarget.getAttributeValue(Attributes.ARMOR_TOUGHNESS) * 0.5) / 100.0));
            }
            if (!(stack = shooter.getItemInHand(bullet.getHand())).is((Item)this)) {
                stack = this.getDefaultInstance();
            }
            if (DamageUtil.doHeavyGunAttack((Entity)shooter, (Entity)bullet, target, arg_0 -> RPG.lambda$doImpactDamage$0(damage = this.getGunDamage(stack) * bulletDmgMultiplier, arg_0)) && shooter instanceof ServerPlayer) {
                LivingEntity livingTarget;
                ServerPlayer pl = (ServerPlayer)shooter;
                if (target instanceof LivingEntity && (livingTarget = (LivingEntity)target).getHealth() == 0.0f && target.hasImpulse && target.level().isEmptyBlock(target.blockPosition().below()) && target.level().isEmptyBlock(target.blockPosition().below(2))) {
                    AdvancementUtil.grantCriterion(pl, AdventOfAscension.id("completionist/surface_to_air"), "rpg_air_kill");
                }
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        for (MutableComponent component : LocaleUtil.getExplosionInfoLocale(AoAExplosions.rpg(entity -> Float.valueOf(1.0f)), flag.isAdvanced(), false)) {
            tooltip.add(2, (Component)component);
        }
    }

    private static /* synthetic */ Float lambda$doImpactDamage$0(float damage, DamageSource source) {
        return Float.valueOf(damage);
    }
}

