/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.cannon;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.cannon.EnergyShotEntity;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.cannon.BaseCannon;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class EnergyCannon
extends BaseCannon {
    public EnergyCannon(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_ENERGY_CANNON_FIRE.get();
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new EnergyShotEntity(shooter, this, hand, 120, 0);
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPosition, float bulletDmgMultiplier) {
        if (target != null) {
            float damage;
            ItemStack stack;
            if (target instanceof LivingEntity) {
                bulletDmgMultiplier = (float)((double)bulletDmgMultiplier * (1.0 + ((LivingEntity)target).getAttribute(Attributes.ARMOR).getValue() * 1.5 / 100.0));
            }
            if (!(stack = shooter.getItemInHand(bullet.getHand())).is((Item)this)) {
                stack = this.getDefaultInstance();
            }
            if (DamageUtil.doHeavyGunAttack((Entity)shooter, (Entity)bullet, target, arg_0 -> EnergyCannon.lambda$doImpactDamage$0(damage = this.getGunDamage(stack) * bulletDmgMultiplier * 0.75f, arg_0))) {
                Player pl;
                if (target instanceof Player && (pl = (Player)target).isBlocking()) {
                    pl.disableShield();
                }
                if (target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    DamageUtil.doScaledKnockback(livingTarget, shooter, damage / 20.0f, 1.0, 1.0, 1.0);
                }
            }
            DamageUtil.doEnergyProjectileAttack((Entity)shooter, (Entity)bullet, target, damage / 3.0f);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    private static /* synthetic */ Float lambda$doImpactDamage$0(float damage, DamageSource source) {
        return Float.valueOf(damage);
    }
}

