/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.cannon;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.cannon.CannonballEntity;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;

public abstract class BaseCannon
extends BaseGun {
    public BaseCannon(Item.Properties properties) {
        super(properties);
    }

    @Override
    public Item getAmmoItem() {
        return (Item)AoAItems.CANNONBALL.get();
    }

    @Override
    public boolean isFullAutomatic() {
        return false;
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, Vec3 impactPosition, float bulletDmgMultiplier) {
        if (target != null) {
            float damage;
            ItemStack stack;
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                bulletDmgMultiplier = (float)((double)bulletDmgMultiplier * (1.0 + (livingTarget.getAttributeValue(Attributes.ARMOR) * 1.5 + livingTarget.getAttributeValue(Attributes.ARMOR_TOUGHNESS) * 0.5) / 100.0));
            }
            if (!(stack = shooter.getItemInHand(bullet.getHand())).is((Item)this)) {
                stack = this.getDefaultInstance();
            }
            if (DamageUtil.doHeavyGunAttack((Entity)shooter, (Entity)bullet, target, arg_0 -> BaseCannon.lambda$doImpactDamage$0(damage = this.getGunDamage(stack) * bulletDmgMultiplier, arg_0))) {
                Player pl;
                if (target instanceof Player && (pl = (Player)target).isBlocking()) {
                    pl.disableShield();
                }
                if (target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    DamageUtil.doScaledKnockback(livingTarget, shooter, damage / 10.0f, 1.0, 1.0, 1.0);
                }
                this.doImpactEffect(target, shooter, bullet, impactPosition, bulletDmgMultiplier);
            }
        }
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new CannonballEntity(shooter, this, hand, 120, 0);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add(2, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.KNOCKBACK, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
        tooltip.add(2, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.CANNON_ARMOUR_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
    }

    private static /* synthetic */ Float lambda$doImpactDamage$0(float damage, DamageSource source) {
        return Float.valueOf(damage);
    }
}

