/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.bow;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class SunshineBow
extends BaseBow {
    public SunshineBow(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void onEntityImpact(CustomArrowEntity arrow, @Nullable Entity shooter, EntityHitResult hitResult, ItemStack stack, float velocity) {
        if (arrow.isCritArrow()) {
            AreaEffectCloud cloud = new AreaEffectCloud(arrow.level(), arrow.getX(), arrow.getY(), arrow.getZ());
            cloud.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0, true, false));
            cloud.setRadius(0.5f);
            cloud.setRadiusPerTick(30.0f);
            cloud.setDuration(2);
            cloud.setWaitTime(0);
            cloud.setPotionContents(new PotionContents(Optional.empty(), Optional.of(0xFFFFFF), List.of()));
            cloud.setParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)0xFFFFFF));
            if (shooter instanceof LivingEntity) {
                cloud.setOwner((LivingEntity)shooter);
            }
            arrow.level().addFreshEntity((Entity)cloud);
            for (LivingEntity entity : EntityRetrievalUtil.getEntities((Level)arrow.level(), (AABB)arrow.getBoundingBox().inflate(30.0, 1.0, 30.0), EntityUtil::isHostileMob)) {
                EntityUtil.applyPotions((Entity)entity, new EffectBuilder(MobEffects.GLOWING, 200));
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

