/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.bow;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.entity.projectile.arrow.PopShotEntity;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;
import net.tslat.aoa3.util.EnchantmentUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class Slingshot
extends BaseBow {
    public static final Predicate<ItemStack> AMMO_PREDICATE = stack -> stack.getItem() == AoAItems.POP_SHOT.get() || stack.getItem() == Items.FLINT;

    public Slingshot(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void onEntityImpact(CustomArrowEntity arrow, @Nullable Entity shooter, EntityHitResult hitResult, ItemStack stack, float velocity) {
        if (arrow instanceof PopShotEntity) {
            PopShotEntity popShot = (PopShotEntity)arrow;
            if (popShot.isExplosive) {
                WorldUtil.createExplosion(shooter, arrow.level(), (Entity)arrow, 1.0f);
            }
        }
        arrow.discard();
    }

    @Override
    public void onBlockImpact(CustomArrowEntity arrow, @Nullable Entity shooter, BlockHitResult hitResult, ItemStack stack) {
        if (arrow instanceof PopShotEntity) {
            PopShotEntity popShot = (PopShotEntity)arrow;
            if (popShot.isExplosive) {
                WorldUtil.createExplosion(shooter, arrow.level(), (Entity)arrow, 1.0f);
            }
        }
        arrow.discard();
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return AMMO_PREDICATE;
    }

    @Override
    public float getArrowDamage(CustomArrowEntity arrow, @Nullable Entity shooter, EntityHitResult hitResult, ItemStack stack, float baseDamage, float velocity, boolean isCritical) {
        float damage = baseDamage * (velocity / 2.0f);
        if (isCritical) {
            damage = (float)((double)damage + ((double)damage + (double)damage * RandomUtil.randomScaledGaussianValue((double)0.35f)));
        }
        return damage;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.PUNCH) || enchantment.is(Enchantments.FLAME)) {
            return false;
        }
        return super.isPrimaryItemFor(stack, enchantment);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return super.isBookEnchantable(stack, book);
    }

    @Override
    protected CustomArrowEntity makeArrow(LivingEntity shooter, ItemStack bowStack, ItemStack ammoStack, float velocity, boolean consumeAmmo) {
        PopShotEntity popShot = new PopShotEntity(shooter.level(), bowStack, shooter, this.getBowDamage(bowStack), ammoStack.getItem() instanceof ArrowItem);
        int powerEnchant = EnchantmentUtil.getEnchantmentLevel(shooter.level(), bowStack, (ResourceKey<Enchantment>)Enchantments.POWER);
        popShot.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, velocity * 2.0f, 1.0f);
        if (powerEnchant > 0) {
            popShot.setBaseDamage(popShot.getBaseDamage() + (double)powerEnchant * 1.5 + 1.0);
        }
        return popShot;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(1, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.ARROW_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.literal((String)Double.toString(this.getBowDamage(stack)))}));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.BOW_DRAW_TIME, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.literal((String)Double.toString((double)(72000.0f / this.drawSpeedMultiplier / 720.0f) / 100.0))}));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.AMMO_ITEM, LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, new Component[]{LocaleUtil.getLocaleMessage(((Item)AoAItems.POP_SHOT.get()).getDescriptionId()).append((Component)Component.literal((String)"/")).append((Component)LocaleUtil.getLocaleMessage(Items.FLINT.getDescriptionId()))}));
    }
}

