/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.bow;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import org.jetbrains.annotations.Nullable;

public class IceBow
extends BaseBow {
    public IceBow(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void onEntityImpact(CustomArrowEntity arrow, @Nullable Entity shooter, EntityHitResult hitResult, ItemStack stack, float velocity) {
        Entity entity = hitResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            MobEffectInstance slowEffect = target.getEffect(MobEffects.MOVEMENT_SLOWDOWN);
            int amp = 0;
            if (slowEffect != null) {
                amp = Math.min(slowEffect.getAmplifier(), 2);
            }
            EntityUtil.applyPotions((Entity)target, new EffectBuilder(MobEffects.MOVEMENT_SLOWDOWN, 40).level(amp + 1));
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

