/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.bow;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.content.item.ArrowFiringWeapon;
import net.tslat.aoa3.content.item.datacomponent.BowStats;
import net.tslat.aoa3.util.EnchantmentUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class BaseBow
extends BowItem
implements ArrowFiringWeapon {
    protected float drawSpeedMultiplier;
    protected double dmg;

    public BaseBow(Item.Properties properties) {
        super(properties);
    }

    public BowStats bowStats(ItemStack bowStack) {
        return (BowStats)bowStack.get((DataComponentType)AoADataComponents.BOW_STATS.get());
    }

    public float getBowDamage(ItemStack bowStack) {
        return this.bowStats(bowStack).damage();
    }

    public float getDrawSpeedMultiplier(ItemStack bowStack) {
        return this.bowStats(bowStack).drawSpeedModifier();
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack heldStack;
        boolean hasAmmo = !this.findAmmo(player, heldStack = player.getItemInHand(hand), player.isCreative()).isEmpty();
        InteractionResultHolder arrowNockEventResult = EventHooks.onArrowNock((ItemStack)heldStack, (Level)world, (Player)player, (InteractionHand)hand, (boolean)hasAmmo);
        if (arrowNockEventResult != null) {
            return arrowNockEventResult;
        }
        if (!player.isCreative() && !hasAmmo) {
            return InteractionResultHolder.fail((Object)heldStack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)heldStack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity shooter, int timeLeft) {
        if (!(shooter instanceof Player)) {
            return;
        }
        Player pl = (Player)shooter;
        boolean infiniteAmmo = pl.isCreative() || EnchantmentUtil.hasEnchantment(level, stack, (ResourceKey<Enchantment>)Enchantments.INFINITY);
        ItemStack ammoStack = this.findAmmo(pl, stack, infiniteAmmo);
        int charge = (int)((float)(this.getUseDuration(stack, shooter) - timeLeft) * this.getDrawSpeedMultiplier(stack));
        if ((charge = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)pl, (int)charge, (!ammoStack.isEmpty() || infiniteAmmo ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (!ammoStack.isEmpty() || infiniteAmmo) {
            float velocity;
            if (ammoStack.isEmpty()) {
                ammoStack = new ItemStack((ItemLike)Items.ARROW);
            }
            if ((velocity = BaseBow.getPowerForTime((int)charge)) >= 0.1f) {
                if (!level.isClientSide) {
                    CustomArrowEntity arrow = this.makeArrow((LivingEntity)pl, stack, ammoStack, velocity, !infiniteAmmo);
                    arrow = this.applyArrowMods(arrow, (Entity)shooter, ammoStack, arrow.isCritArrow());
                    level.addFreshEntity((Entity)arrow);
                }
                level.playSound(null, pl.getX(), pl.getY(), pl.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (float)RandomUtil.randomValueBetween((double)1.2f, (double)1.6f) + velocity * 0.5f);
                if (!infiniteAmmo && !pl.getAbilities().instabuild) {
                    ammoStack.shrink(1);
                    if (ammoStack.isEmpty()) {
                        pl.getInventory().removeItem(ammoStack);
                    }
                }
                pl.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    protected ItemStack findAmmo(Player shooter, ItemStack bowStack, boolean infiniteAmmo) {
        return shooter.getProjectile(bowStack);
    }

    protected CustomArrowEntity makeArrow(LivingEntity shooter, ItemStack bowStack, ItemStack ammoStack, float velocity, boolean consumeAmmo) {
        Player pl;
        ArrowItem arrowItem = (ArrowItem)(ammoStack.getItem() instanceof ArrowItem ? ammoStack.getItem() : Items.ARROW);
        CustomArrowEntity arrow = CustomArrowEntity.fromArrow(arrowItem.createArrow(shooter.level(), ammoStack, shooter, bowStack), bowStack, shooter, this.getBowDamage(bowStack));
        arrow.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, velocity * 3.0f, 1.0f);
        if (velocity == 1.0f) {
            arrow.setCritArrow(true);
        }
        bowStack.hurtAndBreak(this.getDurabilityUse(bowStack), shooter, EntityUtil.handToEquipmentSlotType(shooter.getUsedItemHand()));
        if (!consumeAmmo || shooter instanceof Player && (pl = (Player)shooter).isCreative() && (ammoStack.getItem() == Items.SPECTRAL_ARROW || ammoStack.getItem() == Items.TIPPED_ARROW)) {
            arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        return arrow;
    }

    public int getEnchantmentValue() {
        return 8;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(1, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.ARROW_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.literal((String)Float.toString(this.getBowDamage(stack)))}));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.BOW_DRAW_TIME, LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.literal((String)Double.toString((double)((int)(72000.0f / this.getDrawSpeedMultiplier(stack)) / 720) / 100.0))}));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.AMMO_ITEM, LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, new Component[]{LocaleUtil.getLocaleMessage(Items.ARROW.getDescriptionId())}));
    }
}

