/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.blaster.WinderShotEntity;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class WhimsyWinder
extends BaseBlaster {
    public WhimsyWinder(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_WHIMSY_WINDER_FIRE.get();
    }

    @Override
    public void fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster) {
        shooter.level().addFreshEntity((Entity)new WinderShotEntity(shooter, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        List nearbyTargets = EntityRetrievalUtil.getEntities((Entity)target, (double)3.0, (double)1.0, (double)3.0, entity -> entity instanceof Enemy);
        ItemStack stack = shooter.getItemInHand(InteractionHand.MAIN_HAND);
        if (!stack.is((Item)this)) {
            stack = this.getDefaultInstance();
        }
        nearbyTargets.add(target);
        float splitDmg = (float)((double)(this.getBlasterDamage(stack) / (float)nearbyTargets.size()) * Math.pow(1.05, nearbyTargets.size()));
        boolean success = false;
        for (Entity entity2 : nearbyTargets) {
            success |= DamageUtil.doEnergyProjectileAttack((Entity)shooter, (Entity)shooter, entity2, splitDmg);
        }
        return success;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

