/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.AoASoundBuilderPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.InteractionResults;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.api.particle.transitionworker.ParticleTransitionWorker;
import net.tslat.effectslib.api.particle.transitionworker.PositionParticleTransition;
import net.tslat.effectslib.api.particle.transitionworker.ScaleParticleTransition;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import org.jetbrains.annotations.Nullable;

public class SoulSpark
extends BaseBlaster {
    public SoulSpark(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_BLASTER_ENERGY_PULSE_FIRE.get();
    }

    @Override
    public float getBlasterHeightOffset(EnergyProjectileWeapon weapon, LivingEntity shooter) {
        return -0.3f;
    }

    @Override
    public float getBeamDistance(ItemStack stack, @Nullable LivingEntity shooter) {
        return 2.0f;
    }

    @Override
    public float getChamberLength(EnergyProjectileWeapon weapon, LivingEntity shooter) {
        return 1.0f;
    }

    @Override
    public float getDistToBlasterArm(EnergyProjectileWeapon weapon, LivingEntity shooter) {
        return 0.6f;
    }

    @Override
    public float getSpiritCost(ItemStack stack, @Nullable LivingEntity shooter, boolean forDisplay) {
        if (forDisplay) {
            return 200.0f;
        }
        return super.getSpiritCost(stack, shooter, forDisplay);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand != this.getWeaponHand((LivingEntity)player)) {
            return InteractionResults.ItemUse.denyUsage(stack);
        }
        if (player.getAttackStrengthScale(0.0f) < 1.0f) {
            return InteractionResults.ItemUse.denyUsage(stack);
        }
        float energyCost = this.getSpiritCost(stack, (LivingEntity)player, true);
        if (player.getAbilities().instabuild || PlayerUtil.getResourceValue(player, (AoAResource)AoAResources.SPIRIT.get()) >= energyCost) {
            player.startUsingItem(hand);
            return InteractionResults.ItemUse.noActionTaken(stack);
        }
        if (!player.getAbilities().instabuild) {
            return InteractionResults.ItemUse.denyUsage(stack);
        }
        return InteractionResults.ItemUse.noActionTaken(stack);
    }

    @Override
    protected EnergyProjectileWeapon.ShotInfo fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster, boolean temp) {
        return super.fireBlaster(level, shooter, blaster, false);
    }

    @Override
    public boolean doEntityImpact(ServerLevel level, LivingEntity shooter, ItemStack stack, EnergyProjectileWeapon.ShotInfo shotInfo, EntityHitResult rayTrace) {
        if (!EntityUtil.isImmuneToSpecialAttacks(rayTrace.getEntity())) {
            if (shooter instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)shooter;
                if (!player.getAbilities().instabuild && PlayerUtil.consumeResource(player, (AoAResource)AoAResources.SPIRIT.get(), 200.0f, false)) {
                    InteractionHand hand = player.getUsedItemHand();
                    if (stack.getItem() != this) {
                        stack = player.getItemInHand(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                    }
                    if (stack.getItem() != this) {
                        return false;
                    }
                    Entity target = rayTrace.getEntity();
                    Vec3 center = target.position().add(0.0, (double)(target.getBbHeight() * 0.5f), 0.0);
                    ParticleBuilder.forRandomPosInSphere((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (Vec3)center, (double)(Math.max(target.getBbHeight(), target.getBbWidth()) * 1.1f)).spawnNTimes(1000).scaleMod(1.5f).lifespan(15).colourOverride(0, 100 + shooter.getRandom().nextInt(130), 230, 255).ignoreDistanceAndLimits().addTransition((ParticleTransitionWorker)ScaleParticleTransition.create((float)0.1f, (int)10)).sendToAllPlayersTrackingEntity(player.serverLevel(), (Entity)shooter);
                    ParticleBuilder.forPositionsInSphere((ParticleOptions)ParticleTypes.END_ROD, (Vec3)center, (double)(Math.max(target.getBbHeight(), target.getBbWidth()) * 1.25f), (int)32).colourOverride(0, 230, 230, 255).spawnNTimes(4096).lifespan(20).ignoreDistanceAndLimits().addTransition((ParticleTransitionWorker)PositionParticleTransition.create((Vec3)center, (int)10)).sendToAllPlayersTrackingEntity(player.serverLevel(), (Entity)shooter);
                    AoANetworking.sendToAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder((Holder<SoundEvent>)AoASounds.ITEM_SOUL_SPARK_FIRE).atEntity(rayTrace.getEntity())), (Entity)shooter);
                    rayTrace.getEntity().discard();
                    ItemUtil.damageItemForUser((Player)player, stack, hand);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onUseTick(Level level, LivingEntity shooter, ItemStack stack, int count) {
        if (this.getUseDuration(stack, shooter) - count < this.getChargeTime(stack) - 2) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerPlayer player;
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer serverPlayer = player = shooter instanceof ServerPlayer ? (ServerPlayer)shooter : null;
            if (player == null || player.getCooldowns().getCooldownPercent((Item)this, 0.0f) == 0.0f) {
                if ((player == null || player.getAbilities().instabuild || PlayerUtil.getResourceValue((Player)player, (AoAResource)AoAResources.SPIRIT.get()) >= 200.0f) && this.tryFireBlaster(serverLevel, shooter, stack, player)) {
                    if (player != null) {
                        player.awardStat(Stats.ITEM_USED.get((Object)this));
                        if (this.getTicksBetweenShots(stack) > 1) {
                            player.getCooldowns().addCooldown((Item)this, this.getTicksBetweenShots(stack));
                        }
                    }
                } else {
                    shooter.releaseUsingItem();
                }
            }
        }
    }

    @Override
    protected void doFiringEffects(ServerLevel level, LivingEntity shooter, ItemStack stack, EnergyProjectileWeapon.ShotInfo shotInfo) {
        Vec3 originPos = shotInfo.shotOrBarrelPosForVfx();
        Vec3 hitPos = shotInfo.getHitPos().orElse(originPos);
        TELParticlePacket packet = new TELParticlePacket();
        RandomSource rand = shooter.getRandom();
        packet.particle(ParticleBuilder.forPositionsInLine((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (Vec3)originPos, (Vec3)hitPos, (int)6).colourOverride(0, 100 + rand.nextInt(130), 230, 255).lifespan(1).scaleMod(0.25f + rand.nextFloat() * 0.75f));
        for (int i = 0; i < 3; ++i) {
            packet.particle(ParticleBuilder.forPositionsInLine((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (Vec3)originPos.add(rand.nextGaussian() * (double)0.1f, rand.nextGaussian() * (double)0.1f, rand.nextGaussian() * (double)0.1f), (Vec3)hitPos, (int)6).colourOverride(0, 100 + rand.nextInt(130), 230, 255).lifespan(1).scaleMod(0.25f + rand.nextFloat() * 0.75f));
        }
        packet.send(level);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity player, int useTicksRemaining) {
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.SPEC_IMMUNE, LocaleUtil.ItemDescriptionType.HARMFUL, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

