/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.blaster.OdiousEntity;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class Odious
extends BaseBlaster {
    public Odious(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_SPRAYER_FIRE.get();
    }

    @Override
    public void fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster) {
        shooter.level().addFreshEntity((Entity)new OdiousEntity(shooter, this, 60));
    }

    @Override
    protected void doImpactEffect(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (!EntityUtil.isImmuneToSpecialAttacks(target)) {
            double motionY = target.getDeltaMovement().y();
            EntityUtil.pullEntityIn((Entity)shooter, target, 0.25f, true);
            motionY = Math.min(target.getDeltaMovement().y(), motionY + 0.9);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

