/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.entity.PartEntity;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.entity.projectile.blaster.IroMinerShotEntity;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class IroMiner
extends BaseBlaster {
    public IroMiner(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_MOON_SHINER_FIRE.get();
    }

    @Override
    public void fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster) {
        shooter.level().addFreshEntity((Entity)new IroMinerShotEntity(shooter, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        ItemStack heldStack = shooter.getMainHandItem();
        float damageMod = 1.0f;
        if (heldStack.getItem() == this) {
            UUID targetUUID;
            float damageScaling = ((Float)heldStack.getOrDefault(AoADataComponents.DAMAGE_SCALING, (Object)Float.valueOf(1.0f))).floatValue();
            UUID lastTarget = (UUID)heldStack.getOrDefault(AoADataComponents.LAST_TARGET, null);
            if (target instanceof PartEntity) {
                PartEntity partEntity = (PartEntity)target;
                v0 = partEntity.getParent().getUUID();
            } else {
                v0 = targetUUID = target.getUUID();
            }
            if (targetUUID.equals(lastTarget)) {
                damageMod = damageScaling + 0.02f;
                heldStack.set(AoADataComponents.DAMAGE_SCALING, (Object)Float.valueOf(damageMod));
            } else {
                heldStack.set(AoADataComponents.LAST_TARGET, (Object)targetUUID);
                heldStack.set(AoADataComponents.DAMAGE_SCALING, (Object)Float.valueOf(1.0f));
            }
        }
        return DamageUtil.doEnergyProjectileAttack((Entity)shooter, (Entity)shot, target, this.getBlasterDamage(heldStack) * damageMod);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

