/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.blaster.BloodDrainerEntity;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class BloodDrainer
extends BaseBlaster {
    public BloodDrainer(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_DRAIN_GUN_FIRE.get();
    }

    @Override
    public void fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster) {
        shooter.level().addFreshEntity((Entity)new BloodDrainerEntity(shooter, this, 1));
    }

    @Override
    protected void doImpactEffect(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        EntityUtil.healEntity(shooter, 0.25f);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.LEECHES_HEALTH, LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

