/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.particleoption.EntityTrackingParticleOptions;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;
import net.tslat.aoa3.content.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class BlastChiller
extends BaseBlaster {
    public BlastChiller(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_MAGIC_GUN_FIRE.get();
    }

    @Override
    public float getChamberLength(EnergyProjectileWeapon weapon, LivingEntity shooter) {
        return 1.0f;
    }

    @Override
    public float getBlasterHeightOffset(EnergyProjectileWeapon weapon, LivingEntity shooter) {
        return -0.3f;
    }

    @Override
    protected void doImpactEffect(ServerLevel level, LivingEntity shooter, ItemStack stack, EnergyProjectileWeapon.ShotInfo shotInfo, HitResult rayTrace, boolean affectedTarget) {
        EntityHitResult entityHit;
        Entity entity;
        if (affectedTarget && rayTrace instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)rayTrace).getEntity()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            EntityUtil.applyPotions((Entity)target, new EffectBuilder(MobEffects.MOVEMENT_SLOWDOWN, 40).level(5));
            target.setTicksFrozen(Math.min(300, target.getTicksFrozen() + 15));
        }
    }

    @Override
    protected EnergyProjectileWeapon.ShotInfo fireBlaster(ServerLevel level, LivingEntity shooter, ItemStack blaster, boolean temp) {
        return super.fireBlaster(level, shooter, blaster, false);
    }

    @Override
    protected void doFiringEffects(ServerLevel level, LivingEntity shooter, ItemStack stack, EnergyProjectileWeapon.ShotInfo shotInfo) {
        RandomUtil.EasyRandom rand = RandomUtil.RANDOM;
        TELParticlePacket packet = new TELParticlePacket();
        Vec3 originPos = shotInfo.shotOrBarrelPosForVfx();
        Vec3 hitPos = shotInfo.getHitPos().orElse(originPos);
        packet.particle(ParticleBuilder.forPositionsInLine((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, (Vec3)originPos, (Vec3)hitPos, (int)6).lifespan(10).ignoreDistanceAndLimits().scaleMod(0.25f).colourOverride(0, 168, 162, 120));
        packet.particle(ParticleBuilder.forPositionsInLine((ParticleOptions)EntityTrackingParticleOptions.ambient(AoAParticleTypes.FREEZING_SNOWFLAKE), (Vec3)originPos, (Vec3)hitPos, (int)6).lifespan(rand.nextInt(20, 50)).ignoreDistanceAndLimits().velocity(rand.nextGaussian() * (double)0.05f, rand.nextGaussian() * (double)0.05f, rand.nextGaussian() * (double)0.05f).gravityOverride(0.001f).scaleMod(0.4f));
        packet.particle(ParticleBuilder.forPositionsInLine((ParticleOptions)ParticleTypes.WARPED_SPORE, (Vec3)originPos, (Vec3)hitPos, (int)6).lifespan(rand.nextInt(12, 25)).ignoreDistanceAndLimits().colourOverride(0, 168, 162, 255).spawnNTimes(2));
        packet.sendToAllPlayersTrackingEntity(level, (Entity)shooter);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.SLOWS_TARGETS, LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.FREEZES_TARGETS, LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

