/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.pickaxe;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.LootModifyingItem;
import net.tslat.aoa3.content.item.tool.pickaxe.BasePickaxe;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class SkeletalPickaxe
extends BasePickaxe
implements LootModifyingItem {
    public SkeletalPickaxe(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public void doLootModification(List<ItemStack> existingLoot, LootContext lootContext) {
        BlockState harvestedBlock = this.getHarvestedBlock(lootContext);
        Block block = harvestedBlock.getBlock();
        if (block == Blocks.AIR || existingLoot.isEmpty() || this.getDestroySpeed(this.getToolStack(lootContext), harvestedBlock) <= 1.0f) {
            return;
        }
        if (RandomUtil.oneInNChance((int)10)) {
            int dropChoice = RandomUtil.randomNumberUpTo((int)50);
            ItemStack drop = dropChoice == 0 ? new ItemStack((ItemLike)RandomUtil.getRandomSelection((Object[])new Item[]{(Item)AoAItems.SKULLBONE_FRAGMENT.get(), (Item)AoAItems.CHESTBONE_FRAGMENT.get(), (Item)AoAItems.LEGBONE_FRAGMENT.get(), (Item)AoAItems.FOOTBONE_FRAGMENT.get()})) : (dropChoice < 10 ? new ItemStack((ItemLike)Items.BONE_MEAL) : new ItemStack((ItemLike)Items.BONE));
            existingLoot.add(drop);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.SKELETAL_TOOL_DESCRIPTION, LocaleUtil.ItemDescriptionType.UNIQUE, new Component[0]));
    }
}

