/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.pickaxe;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.content.item.tool.pickaxe.BasePickaxe;
import net.tslat.aoa3.util.LocaleUtil;

public class GoofyPickaxe
extends BasePickaxe {
    public GoofyPickaxe(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.isClientSide && stack.isDamaged()) {
            int modulo = selected ? 120 : (slot < 9 ? 200 : 280);
            if (world.getGameTime() % (long)modulo == 0L) {
                stack.setDamageValue(stack.getDamageValue() - 1);
                if (entity instanceof Player) {
                    Player pl = (Player)entity;
                    pl.inventoryMenu.broadcastChanges();
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.GOOFY_TOOL_REGEN, LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.NO_DAMAGE, LocaleUtil.ItemDescriptionType.HARMFUL, new Component[0]));
    }
}

