/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.pickaxe;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.tslat.aoa3.content.item.LootModifyingItem;
import net.tslat.aoa3.content.item.tool.pickaxe.BasePickaxe;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;

public class EmberstonePickaxe
extends BasePickaxe
implements LootModifyingItem {
    public EmberstonePickaxe(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public void doLootModification(List<ItemStack> existingLoot, LootContext lootContext) {
        BlockState harvestedBlock = this.getHarvestedBlock(lootContext);
        Block block = harvestedBlock.getBlock();
        if (block == Blocks.AIR || existingLoot.isEmpty() || this.getDestroySpeed(this.getToolStack(lootContext), harvestedBlock) <= 1.0f) {
            return;
        }
        ServerLevel level = lootContext.getLevel();
        BlockPos pos = BlockPos.containing((Position)((Position)lootContext.getParamOrNull(LootContextParams.ORIGIN)));
        int i = 0;
        while (i < existingLoot.size()) {
            ItemStack stack = existingLoot.get(i);
            Optional<SmeltingRecipe> smeltRecipe = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)level).map(RecipeHolder::value);
            int index = i++;
            smeltRecipe.ifPresent(recipe -> {
                ItemStack smeltedStack = recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                smeltedStack.setCount(smeltedStack.getCount() * stack.getCount());
                existingLoot.set(index, smeltedStack);
                block.popExperience(level, pos, (int)recipe.getExperience());
                ParticleBuilder.forRandomPosInBlock((ParticleOptions)ParticleTypes.FLAME, (BlockPos)pos).spawnNTimes(5).sendToAllPlayersTrackingBlock(level, pos);
            });
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

