/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.misc;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.content.entity.misc.HaulingFishingBobberEntity;
import net.tslat.aoa3.event.custom.AoAEvents;
import net.tslat.aoa3.event.custom.events.HaulingItemFishedEvent;
import net.tslat.aoa3.event.custom.events.HaulingRodPullEntityEvent;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LootUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.smartbrainlib.util.RandomUtil;

public class HaulingRod
extends FishingRodItem {
    public HaulingRod(Item.Properties itemProperties) {
        super(itemProperties);
    }

    public int getUseDuration(ItemStack pStack, LivingEntity user) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ServerPlayer pl;
        HaulingFishingBobberEntity bobber;
        ItemStack stack = player.getItemInHand(hand);
        if (player.fishing != null && player.fishing.level() == player.level()) {
            FishingHook fishingHook = player.fishing;
            if (fishingHook instanceof HaulingFishingBobberEntity) {
                HaulingFishingBobberEntity bobber2 = (HaulingFishingBobberEntity)fishingHook;
                if (bobber2.getState() == HaulingFishingBobberEntity.State.HOOKED_FISH) {
                    if (!level.isClientSide) {
                        new SoundBuilder((Holder<SoundEvent>)AoASounds.ITEM_HAULING_ROD_REEL_IN).followEntity((Entity)player).execute();
                        ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.BUBBLE, (Entity)player.fishing).sendToAllPlayersTrackingEntity((ServerLevel)level, (Entity)player.fishing);
                        ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.SPLASH, (Entity)player.fishing).sendToAllPlayersTrackingEntity((ServerLevel)level, (Entity)player.fishing);
                    }
                    this.reelIn(player, bobber2, stack, hand);
                    if (!player.isUsingItem()) {
                        player.startUsingItem(hand);
                    }
                    return InteractionResultHolder.fail((Object)stack);
                }
                if (bobber2.getState() == HaulingFishingBobberEntity.State.HOOKED_IN_ENTITY) {
                    this.landEntity(player, stack, hand, bobber2);
                    if (!player.isUsingItem()) {
                        player.startUsingItem(hand);
                    }
                } else if (!level.isClientSide) {
                    bobber2.discard();
                    player.fishing = null;
                }
            } else if (!level.isClientSide) {
                player.fishing.discard();
                player.fishing = null;
            }
        } else if (player instanceof ServerPlayer && (bobber = this.getNewBobber(player, stack, this.getLureMod(pl = (ServerPlayer)player, stack), this.getLuckMod(pl, stack))) != null) {
            level.addFreshEntity((Entity)bobber);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            this.playCastSound(player, bobber, stack);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    protected void reelIn(Player player, HaulingFishingBobberEntity bobber, ItemStack stack, InteractionHand hand) {
        if (bobber.distanceToSqr((Entity)player) <= 9.0) {
            if (player instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                List<ItemStack> loot = this.landEntity((Player)pl, stack, hand, bobber);
                int xp = RandomUtil.randomNumberBetween((int)2, (int)10);
                HaulingItemFishedEvent event = AoAEvents.fireHaulingItemFished(bobber.getHookedIn(), stack, loot, xp, 1, bobber);
                if (!event.isCanceled()) {
                    this.handleLureRetrieval(pl, stack, bobber, loot);
                    for (ItemStack lootStack : loot) {
                        ItemEntity entity = new ItemEntity(pl.level(), bobber.getX(), bobber.getY(), bobber.getZ(), lootStack);
                        double velX = pl.getX() - bobber.getX();
                        double velY = pl.getY() - bobber.getY();
                        double velZ = pl.getZ() - bobber.getZ();
                        Vec3 pullVec = new Vec3(velX, velY + Math.sqrt(Math.sqrt(velX * velX + velY * velY + velZ * velZ)), velZ).scale(0.1);
                        entity.setDeltaMovement(pullVec);
                        pl.level().addFreshEntity((Entity)entity);
                        if (!pl.onGround()) {
                            pl.setDeltaMovement(pullVec.reverse());
                        }
                        if (!lootStack.is(ItemTags.FISHES)) continue;
                        pl.awardStat(Stats.FISH_CAUGHT, 1);
                    }
                }
                ItemUtil.damageItemForUser((Player)pl, stack, event.getRodDamage(), hand);
                pl.level().addFreshEntity((Entity)new ExperienceOrb(pl.level(), pl.getX() + 0.5, pl.getY() + 0.5, pl.getZ() + 0.5, event.getXp()));
                bobber.discard();
            }
        } else {
            Entity hookedEntity = bobber.getHookedIn();
            if (hookedEntity != null) {
                float pullStrength = this.getHaulStrengthMod(player, stack, bobber);
                EntityUtil.pullEntityIn((Entity)player, hookedEntity, 0.25f * pullStrength, true);
                hookedEntity.setDeltaMovement(hookedEntity.getDeltaMovement().multiply(1.0, 0.5, 1.0));
                if (!player.onGround() && bobber.getState() == HaulingFishingBobberEntity.State.HOOKED_IN_ENTITY) {
                    EntityUtil.pullEntityIn(hookedEntity, (Entity)player, 0.25f * pullStrength, true);
                }
            }
        }
    }

    protected List<ItemStack> landEntity(Player player, ItemStack stack, InteractionHand hand, HaulingFishingBobberEntity bobber) {
        Entity hookedEntity = bobber.getHookedIn();
        if (hookedEntity != null && hookedEntity.isAlive()) {
            float pullStrength = this.getHaulStrengthMod(player, stack, bobber);
            if (bobber.getState() == HaulingFishingBobberEntity.State.HOOKED_IN_ENTITY) {
                HaulingRodPullEntityEvent event = AoAEvents.fireHaulingRodPullEntity(player, stack, bobber, hookedEntity, 0, pullStrength);
                if (event.isCanceled()) {
                    return Collections.emptyList();
                }
                pullStrength = event.getPullStrength();
                if (event.getAdditionalRodDamage() > 0 && !player.level().isClientSide) {
                    ItemUtil.damageItemForUser(player, stack, event.getAdditionalRodDamage(), hand);
                }
            }
            EntityUtil.pullEntityIn((Entity)player, hookedEntity, pullStrength, true);
            hookedEntity.setDeltaMovement(hookedEntity.getDeltaMovement().multiply(1.0, 0.25, 1.0));
            if (!player.onGround() && bobber.getState() == HaulingFishingBobberEntity.State.HOOKED_IN_ENTITY) {
                EntityUtil.pullEntityIn(hookedEntity, (Entity)player, 0.25f * pullStrength, true);
            }
            player.getCooldowns().addCooldown((Item)this, 10);
            return player instanceof ServerPlayer ? this.getLootForHauledEntity((ServerPlayer)player, stack, bobber, hookedEntity) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected List<ItemStack> getLootForHauledEntity(ServerPlayer player, ItemStack stack, HaulingFishingBobberEntity bobber, Entity hookedEntity) {
        if (bobber.getState() == HaulingFishingBobberEntity.State.HOOKED_IN_ENTITY) {
            return Collections.emptyList();
        }
        Entity entity = hookedEntity;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemEntity.class, LivingEntity.class}, (Object)entity, n)) {
            case 0 -> {
                ItemEntity itemEntity = (ItemEntity)entity;
                yield ObjectArrayList.of((Object[])new ItemStack[]{itemEntity.getItem()});
            }
            case 1 -> {
                LivingEntity livingEntity = (LivingEntity)entity;
                yield ObjectArrayList.of((Object[])LootUtil.generateLoot((ResourceKey<LootTable>)livingEntity.getLootTable(), new LootParams.Builder(player.serverLevel()).withParameter(LootContextParams.ORIGIN, (Object)bobber.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)this.killHaulingEntity(bobber, (Player)player, livingEntity)).withParameter(LootContextParams.TOOL, (Object)stack).withParameter(LootContextParams.THIS_ENTITY, (Object)bobber).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)bobber).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withLuck(bobber.getLuck()).create(LootContextParamSets.ENTITY)).toArray(new ItemStack[0]));
            }
            default -> Collections.emptyList();
        };
    }

    protected void handleLureRetrieval(ServerPlayer player, ItemStack stack, HaulingFishingBobberEntity bobber, Collection<ItemStack> loot) {
        this.playRetrievalSound((Player)player, bobber, stack);
        CriteriaTriggers.FISHING_ROD_HOOKED.trigger(player, stack, (FishingHook)bobber, loot);
        player.getCooldowns().addCooldown((Item)this, 5);
    }

    protected void playRetrievalSound(Player player, HaulingFishingBobberEntity bobber, ItemStack stack) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (float)RandomUtil.randomValueBetween((double)0.8f, (double)1.2f));
    }

    protected void playCastSound(Player player, HaulingFishingBobberEntity bobber, ItemStack stack) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (float)RandomUtil.randomValueBetween((double)0.8f, (double)1.2f));
    }

    protected HaulingFishingBobberEntity getNewBobber(Player player, ItemStack stack, float lureMod, float luckMod) {
        return new HaulingFishingBobberEntity(player, player.level(), stack, luckMod, lureMod);
    }

    public float getHaulStrengthMod(Player player, ItemStack stack, HaulingFishingBobberEntity bobber) {
        return 1.0f;
    }

    public float getLureMod(ServerPlayer player, ItemStack stack) {
        return EnchantmentHelper.getFishingTimeReduction((ServerLevel)player.serverLevel(), (ItemStack)stack, (Entity)player);
    }

    public int getLuckMod(ServerPlayer player, ItemStack stack) {
        return EnchantmentHelper.getFishingLuckBonus((ServerLevel)player.serverLevel(), (ItemStack)stack, (Entity)player);
    }

    private DamageSource killHaulingEntity(FishingHook bobber, Player player, LivingEntity target) {
        DamageSource damageSource;
        target.lastDamageSource = damageSource = DamageUtil.indirectEntityDamage(AoADamageTypes.HAULING, (Entity)player, (Entity)bobber);
        target.setLastHurtByMob((LivingEntity)player);
        target.setLastHurtByPlayer(player);
        target.setHealth(0.0f);
        player.awardKillScore((Entity)target, 1, damageSource);
        target.discard();
        return damageSource;
    }
}

