/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.misc;

import java.util.List;
import java.util.ListIterator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.content.entity.misc.GoldFishingBobberEntity;
import net.tslat.aoa3.content.entity.misc.HaulingFishingBobberEntity;
import net.tslat.aoa3.content.item.tool.misc.HaulingRod;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class GoldenRod
extends HaulingRod {
    public GoldenRod(Item.Properties itemProperties) {
        super(itemProperties);
    }

    @Override
    public int getLuckMod(ServerPlayer player, ItemStack stack) {
        return super.getLuckMod(player, stack) + 3;
    }

    @Override
    protected List<ItemStack> getLootForHauledEntity(ServerPlayer player, ItemStack stack, HaulingFishingBobberEntity bobber, Entity hookedEntity) {
        List<ItemStack> loot = super.getLootForHauledEntity(player, stack, bobber, hookedEntity);
        ListIterator<ItemStack> iterator = loot.listIterator();
        while (iterator.hasNext()) {
            ItemStack itStack = iterator.next();
            ItemUtil.increaseStackSize(itStack, itStack.getCount()).forEach(iterator::add);
        }
        return loot;
    }

    @Override
    protected HaulingFishingBobberEntity getNewBobber(Player player, ItemStack stack, float lureMod, float luckMod) {
        return new GoldFishingBobberEntity(player, player.level(), stack, luckMod, lureMod);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

