/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.hoe;

import java.util.List;
import java.util.ListIterator;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.tslat.aoa3.common.registration.item.AoATiers;
import net.tslat.aoa3.content.item.LootModifyingItem;
import net.tslat.aoa3.content.item.tool.hoe.BaseHoe;
import net.tslat.aoa3.library.constant.AttackSpeed;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class DryadsBlessing
extends BaseHoe
implements LootModifyingItem {
    public DryadsBlessing() {
        super(AoATiers.DRYADS_BLESSING, 0.0f, AttackSpeed.forAttacksPerSecond(4.0f));
    }

    @Override
    public void doLootModification(List<ItemStack> existingLoot, LootContext lootContext) {
        BlockState harvestedBlock = this.getHarvestedBlock(lootContext);
        Block block = harvestedBlock.getBlock();
        if (existingLoot.isEmpty() || !(block instanceof CropBlock)) {
            return;
        }
        if (!((CropBlock)block).isMaxAge(harvestedBlock)) {
            return;
        }
        ListIterator<ItemStack> iterator = existingLoot.listIterator();
        while (iterator.hasNext()) {
            ItemStack itStack = iterator.next();
            ItemUtil.increaseStackSize(itStack, itStack.getCount()).forEach(iterator::add);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }
}

