/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tool.axe;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.content.item.LootModifyingItem;
import net.tslat.aoa3.content.item.tool.axe.BaseAxe;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class SoulstoneAxe
extends BaseAxe
implements LootModifyingItem {
    public SoulstoneAxe(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public void doLootModification(List<ItemStack> existingLoot, LootContext lootContext) {
        BlockState harvestedBlock = this.getHarvestedBlock(lootContext);
        Block block = harvestedBlock.getBlock();
        if (block == Blocks.AIR || existingLoot.isEmpty() || this.getDestroySpeed(this.getToolStack(lootContext), harvestedBlock) <= 1.0f || !harvestedBlock.is(BlockTags.LOGS) || !lootContext.hasParam(LootContextParams.THIS_ENTITY)) {
            return;
        }
        Entity harvestingPlayer = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (!(harvestingPlayer instanceof ServerPlayer)) {
            return;
        }
        ServerLevel world = lootContext.getLevel();
        Vec3 pos = (Vec3)lootContext.getParamOrNull(LootContextParams.ORIGIN);
        ItemStack blockDrop = ItemStack.EMPTY;
        Item blockItem = block.asItem();
        for (ItemStack stack : existingLoot) {
            if (stack.getItem() != blockItem) continue;
            blockDrop = stack;
            break;
        }
        if (blockDrop == ItemStack.EMPTY) {
            blockDrop = existingLoot.get(0);
        }
        if (blockDrop != ItemStack.EMPTY && PlayerUtil.consumeResource((ServerPlayer)harvestingPlayer, (AoAResource)AoAResources.SPIRIT.get(), 5.0f, false)) {
            blockDrop.setCount(blockDrop.getCount() * 2);
            for (int i = 0; i < 5; ++i) {
                world.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, pos.x + (double)RandomUtil.randomValueUpTo((float)1.0f), pos.y + (double)RandomUtil.randomValueUpTo((float)1.0f), pos.z + (double)RandomUtil.randomValueUpTo((float)1.0f), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

