/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc.summoning;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.content.entity.boss.skeletron.SkeletronEntity;
import net.tslat.aoa3.content.item.misc.summoning.BossSpawningItem;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class WarpedHorn
extends BossSpawningItem<SkeletronEntity> {
    public WarpedHorn() {
        super(0, new Item.Properties().rarity(Rarity.RARE).stacksTo(1));
    }

    public SkeletronEntity spawnBoss(ServerLevel level, Vec3 position, ItemStack stack, int playerCount) {
        SkeletronEntity skeletron = (SkeletronEntity)EntitySpawningUtil.spawnEntity(level, (EntityType)AoAMonsters.SKELETRON.get(), position, MobSpawnType.TRIGGERED);
        if (playerCount > 1 && skeletron != null) {
            AttributeUtil.applyPermanentModifier((LivingEntity)skeletron, (Holder<Attribute>)Attributes.MAX_HEALTH, this.getPerPlayerHealthBuff(playerCount));
            skeletron.setHealth(skeletron.getMaxHealth());
        }
        return skeletron;
    }

    @Nullable
    public EntityType<SkeletronEntity> getEntityType(ItemStack stack) {
        return (EntityType)AoAMonsters.SKELETRON.get();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 2, new Component[0]));
    }
}

