/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.misc.summoning;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.content.entity.boss.smash.SmashEntity;
import net.tslat.aoa3.content.item.misc.summoning.BossSpawningItem;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class TrollIdol
extends BossSpawningItem<SmashEntity> {
    public TrollIdol() {
        super(0, new Item.Properties().rarity(Rarity.RARE).durability(20).setNoRepair());
    }

    public SmashEntity spawnBoss(ServerLevel level, Vec3 position, ItemStack stack, int playerCount) {
        SmashEntity smash = (SmashEntity)EntitySpawningUtil.spawnEntity(level, (EntityType)AoAMonsters.SMASH.get(), position, MobSpawnType.TRIGGERED);
        if (playerCount > 1 && smash != null) {
            AttributeUtil.applyPermanentModifier((LivingEntity)smash, (Holder<Attribute>)Attributes.MAX_HEALTH, this.getPerPlayerHealthBuff(playerCount));
            smash.setHealth(smash.getMaxHealth());
        }
        return smash;
    }

    public EntityType<SmashEntity> getEntityType(ItemStack stack) {
        return stack.isDamaged() ? null : (EntityType)AoAMonsters.SMASH.get();
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.getItemInHand(hand).isDamaged()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!stack.isDamaged() || !target.getType().is(EntityTypeTags.UNDEAD) || target.getHealth() > 0.0f) {
            return true;
        }
        stack.setDamageValue(stack.getDamageValue() - 1);
        return true;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (!stack.isDamaged()) {
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new Component[0]));
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 2, new Component[0]));
        } else {
            tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.NEUTRAL, 3, new Component[0]));
        }
    }
}

